/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import systems.dennis.flaw.annotation.MoveField;
import systems.dennis.flaw.model.EpicModel;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupableModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.Iconable;
import systems.dennis.flaw.model.ImportModel;
import systems.dennis.flaw.model.IssueFlowModel;
import systems.dennis.flaw.model.IssueStatusModel;
import systems.dennis.flaw.model.IssueTypeModel;
import systems.dennis.flaw.model.PriorityModel;
import systems.dennis.flaw.model.ProjectModel;
import systems.dennis.flaw.model.SolutionTypeModel;
import systems.dennis.flaw.model.SprintModel;
import systems.dennis.flaw.model.StoryModel;
import systems.dennis.flaw.model.TeamModel;
import systems.dennis.flaw.service.EpicService;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.IssueFlowService;
import systems.dennis.flaw.service.IssueStatusService;
import systems.dennis.flaw.service.IssueTypeService;
import systems.dennis.flaw.service.PriorityService;
import systems.dennis.flaw.service.ProjectService;
import systems.dennis.flaw.service.SolutionTypeService;
import systems.dennis.flaw.service.StoryService;
import systems.dennis.flaw.service.TeamService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.flaw.service.sprint.SprintService;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateTimeAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class IssueModel
extends ImportModel
implements Iconable,
GroupableModel {
    @MoveField
    private String name;
    @MoveField
    private String icon;
    @ElementCollection
    @MoveField
    private List<String> icons = new ArrayList();
    @Column(columnDefinition="text")
    @MoveField
    private String description;
    @FormTransient
    @DataTransformer(transFormWith=DateTimeAndStringConverter.class, params={"dd.MM.yy HH:mm"})
    @MoveField
    private Date created;
    @FormTransient
    @DataTransformer(transFormWith=DateTimeAndStringConverter.class, params={"dd.MM.yy HH:mm"})
    @MoveField
    private Date lastStatusChange;
    @FormTransient
    @DataTransformer(transFormWith=DateTimeAndStringConverter.class, params={"dd.MM.yy HH:mm"})
    @MoveField
    private Date finishedOn;
    @OneToOne
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueStatusService.class)
    @MoveField
    private IssueStatusModel status;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueTypeService.class)
    @MoveField
    private IssueTypeModel issueType;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueFlowService.class)
    @MoveField(createPolicy=2)
    private IssueFlowModel issueFlow;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=ProjectService.class)
    @MoveField
    private ProjectModel project;
    @OneToOne
    @MoveField
    @DataTransformer(additionalClass=EpicService.class, transFormWith=IdToObjectTransformer.class)
    private EpicModel epic;
    @OneToOne
    @ObjectByIdPresentation
    @DataTransformer(additionalClass=SprintService.class, transFormWith=IdToObjectTransformer.class)
    private SprintModel sprint;
    @OneToOne
    @DataTransformer(additionalClass=StoryService.class, transFormWith=IdToObjectTransformer.class)
    @MoveField
    private StoryModel story;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=GroupService.class)
    protected GroupModel group;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueService.class)
    private IssueModel parent;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=HRService.class)
    @MoveField(createPolicy=1)
    private HRModel performer;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=TeamService.class)
    @MoveField(createPolicy=1)
    private TeamModel performersTeam;
    @OneToOne
    @FormTransient
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=HRService.class)
    @MoveField(createPolicy=1)
    private HRModel creator;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=HRService.class)
    @MoveField(createPolicy=1)
    private HRModel tester;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=SolutionTypeService.class)
    @MoveField
    private SolutionTypeModel solutionType;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=PriorityService.class)
    @MoveField
    private PriorityModel priority;
    @MoveField
    private Boolean forAchieveTests = false;
    @FormTransient
    @Transient
    boolean forceUpdate = false;

    public String asValue() {
        return this.name;
    }

    public GroupModel findInnerGroup() {
        if (this.story != null) {
            return this.story.getGroup();
        }
        if (this.epic != null) {
            return this.epic.getGroup();
        }
        if (this.sprint != null) {
            return this.sprint.getGroup();
        }
        if (this.project != null) {
            return this.project.getGroup();
        }
        return null;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getIcons() {
        return this.icons;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getLastStatusChange() {
        return this.lastStatusChange;
    }

    public Date getFinishedOn() {
        return this.finishedOn;
    }

    public IssueStatusModel getStatus() {
        return this.status;
    }

    public IssueTypeModel getIssueType() {
        return this.issueType;
    }

    public IssueFlowModel getIssueFlow() {
        return this.issueFlow;
    }

    public ProjectModel getProject() {
        return this.project;
    }

    public EpicModel getEpic() {
        return this.epic;
    }

    public SprintModel getSprint() {
        return this.sprint;
    }

    public StoryModel getStory() {
        return this.story;
    }

    public GroupModel getGroup() {
        return this.group;
    }

    public IssueModel getParent() {
        return this.parent;
    }

    public HRModel getPerformer() {
        return this.performer;
    }

    public TeamModel getPerformersTeam() {
        return this.performersTeam;
    }

    public HRModel getCreator() {
        return this.creator;
    }

    public HRModel getTester() {
        return this.tester;
    }

    public SolutionTypeModel getSolutionType() {
        return this.solutionType;
    }

    public PriorityModel getPriority() {
        return this.priority;
    }

    public Boolean getForAchieveTests() {
        return this.forAchieveTests;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setIcons(List<String> icons) {
        this.icons = icons;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setLastStatusChange(Date lastStatusChange) {
        this.lastStatusChange = lastStatusChange;
    }

    public void setFinishedOn(Date finishedOn) {
        this.finishedOn = finishedOn;
    }

    public void setStatus(IssueStatusModel status) {
        this.status = status;
    }

    public void setIssueType(IssueTypeModel issueType) {
        this.issueType = issueType;
    }

    public void setIssueFlow(IssueFlowModel issueFlow) {
        this.issueFlow = issueFlow;
    }

    public void setProject(ProjectModel project) {
        this.project = project;
    }

    public void setEpic(EpicModel epic) {
        this.epic = epic;
    }

    public void setSprint(SprintModel sprint) {
        this.sprint = sprint;
    }

    public void setStory(StoryModel story) {
        this.story = story;
    }

    public void setGroup(GroupModel group) {
        this.group = group;
    }

    public void setParent(IssueModel parent) {
        this.parent = parent;
    }

    public void setPerformer(HRModel performer) {
        this.performer = performer;
    }

    public void setPerformersTeam(TeamModel performersTeam) {
        this.performersTeam = performersTeam;
    }

    public void setCreator(HRModel creator) {
        this.creator = creator;
    }

    public void setTester(HRModel tester) {
        this.tester = tester;
    }

    public void setSolutionType(SolutionTypeModel solutionType) {
        this.solutionType = solutionType;
    }

    public void setPriority(PriorityModel priority) {
        this.priority = priority;
    }

    public void setForAchieveTests(Boolean forAchieveTests) {
        this.forAchieveTests = forAchieveTests;
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IssueModel)) {
            return false;
        }
        IssueModel other = (IssueModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isForceUpdate() != other.isForceUpdate()) {
            return false;
        }
        Boolean this$forAchieveTests = this.getForAchieveTests();
        Boolean other$forAchieveTests = other.getForAchieveTests();
        if (this$forAchieveTests == null ? other$forAchieveTests != null : !((Object)this$forAchieveTests).equals(other$forAchieveTests)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        List this$icons = this.getIcons();
        List other$icons = other.getIcons();
        if (this$icons == null ? other$icons != null : !((Object)this$icons).equals(other$icons)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Date this$created = this.getCreated();
        Date other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Date this$lastStatusChange = this.getLastStatusChange();
        Date other$lastStatusChange = other.getLastStatusChange();
        if (this$lastStatusChange == null ? other$lastStatusChange != null : !((Object)this$lastStatusChange).equals(other$lastStatusChange)) {
            return false;
        }
        Date this$finishedOn = this.getFinishedOn();
        Date other$finishedOn = other.getFinishedOn();
        if (this$finishedOn == null ? other$finishedOn != null : !((Object)this$finishedOn).equals(other$finishedOn)) {
            return false;
        }
        IssueStatusModel this$status = this.getStatus();
        IssueStatusModel other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        IssueTypeModel this$issueType = this.getIssueType();
        IssueTypeModel other$issueType = other.getIssueType();
        if (this$issueType == null ? other$issueType != null : !this$issueType.equals(other$issueType)) {
            return false;
        }
        IssueFlowModel this$issueFlow = this.getIssueFlow();
        IssueFlowModel other$issueFlow = other.getIssueFlow();
        if (this$issueFlow == null ? other$issueFlow != null : !this$issueFlow.equals(other$issueFlow)) {
            return false;
        }
        ProjectModel this$project = this.getProject();
        ProjectModel other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        EpicModel this$epic = this.getEpic();
        EpicModel other$epic = other.getEpic();
        if (this$epic == null ? other$epic != null : !this$epic.equals(other$epic)) {
            return false;
        }
        SprintModel this$sprint = this.getSprint();
        SprintModel other$sprint = other.getSprint();
        if (this$sprint == null ? other$sprint != null : !this$sprint.equals(other$sprint)) {
            return false;
        }
        StoryModel this$story = this.getStory();
        StoryModel other$story = other.getStory();
        if (this$story == null ? other$story != null : !this$story.equals(other$story)) {
            return false;
        }
        GroupModel this$group = this.getGroup();
        GroupModel other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        IssueModel this$parent = this.getParent();
        IssueModel other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        HRModel this$performer = this.getPerformer();
        HRModel other$performer = other.getPerformer();
        if (this$performer == null ? other$performer != null : !this$performer.equals(other$performer)) {
            return false;
        }
        TeamModel this$performersTeam = this.getPerformersTeam();
        TeamModel other$performersTeam = other.getPerformersTeam();
        if (this$performersTeam == null ? other$performersTeam != null : !this$performersTeam.equals(other$performersTeam)) {
            return false;
        }
        HRModel this$creator = this.getCreator();
        HRModel other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        HRModel this$tester = this.getTester();
        HRModel other$tester = other.getTester();
        if (this$tester == null ? other$tester != null : !this$tester.equals(other$tester)) {
            return false;
        }
        SolutionTypeModel this$solutionType = this.getSolutionType();
        SolutionTypeModel other$solutionType = other.getSolutionType();
        if (this$solutionType == null ? other$solutionType != null : !this$solutionType.equals(other$solutionType)) {
            return false;
        }
        PriorityModel this$priority = this.getPriority();
        PriorityModel other$priority = other.getPriority();
        return !(this$priority == null ? other$priority != null : !this$priority.equals(other$priority));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IssueModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForceUpdate() ? 79 : 97);
        Boolean $forAchieveTests = this.getForAchieveTests();
        result = result * 59 + ($forAchieveTests == null ? 43 : ((Object)$forAchieveTests).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        List $icons = this.getIcons();
        result = result * 59 + ($icons == null ? 43 : ((Object)$icons).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Date $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Date $lastStatusChange = this.getLastStatusChange();
        result = result * 59 + ($lastStatusChange == null ? 43 : ((Object)$lastStatusChange).hashCode());
        Date $finishedOn = this.getFinishedOn();
        result = result * 59 + ($finishedOn == null ? 43 : ((Object)$finishedOn).hashCode());
        IssueStatusModel $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        IssueTypeModel $issueType = this.getIssueType();
        result = result * 59 + ($issueType == null ? 43 : $issueType.hashCode());
        IssueFlowModel $issueFlow = this.getIssueFlow();
        result = result * 59 + ($issueFlow == null ? 43 : $issueFlow.hashCode());
        ProjectModel $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        EpicModel $epic = this.getEpic();
        result = result * 59 + ($epic == null ? 43 : $epic.hashCode());
        SprintModel $sprint = this.getSprint();
        result = result * 59 + ($sprint == null ? 43 : $sprint.hashCode());
        StoryModel $story = this.getStory();
        result = result * 59 + ($story == null ? 43 : $story.hashCode());
        GroupModel $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        IssueModel $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        HRModel $performer = this.getPerformer();
        result = result * 59 + ($performer == null ? 43 : $performer.hashCode());
        TeamModel $performersTeam = this.getPerformersTeam();
        result = result * 59 + ($performersTeam == null ? 43 : $performersTeam.hashCode());
        HRModel $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        HRModel $tester = this.getTester();
        result = result * 59 + ($tester == null ? 43 : $tester.hashCode());
        SolutionTypeModel $solutionType = this.getSolutionType();
        result = result * 59 + ($solutionType == null ? 43 : $solutionType.hashCode());
        PriorityModel $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : $priority.hashCode());
        return result;
    }

    public String toString() {
        return "IssueModel(name=" + this.getName() + ", icon=" + this.getIcon() + ", icons=" + String.valueOf(this.getIcons()) + ", description=" + this.getDescription() + ", created=" + String.valueOf(this.getCreated()) + ", lastStatusChange=" + String.valueOf(this.getLastStatusChange()) + ", finishedOn=" + String.valueOf(this.getFinishedOn()) + ", status=" + String.valueOf(this.getStatus()) + ", issueType=" + String.valueOf(this.getIssueType()) + ", issueFlow=" + String.valueOf(this.getIssueFlow()) + ", project=" + String.valueOf(this.getProject()) + ", epic=" + String.valueOf(this.getEpic()) + ", sprint=" + String.valueOf(this.getSprint()) + ", story=" + String.valueOf(this.getStory()) + ", group=" + String.valueOf(this.getGroup()) + ", parent=" + String.valueOf(this.getParent()) + ", performer=" + String.valueOf(this.getPerformer()) + ", performersTeam=" + String.valueOf(this.getPerformersTeam()) + ", creator=" + String.valueOf(this.getCreator()) + ", tester=" + String.valueOf(this.getTester()) + ", solutionType=" + String.valueOf(this.getSolutionType()) + ", priority=" + String.valueOf(this.getPriority()) + ", forAchieveTests=" + this.getForAchieveTests() + ", forceUpdate=" + this.isForceUpdate() + ")";
    }
}

