/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import org.springframework.data.domain.Sort;
import systems.dennis.flaw.annotation.MoveField;
import systems.dennis.flaw.model.DemoModel;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupableModel;
import systems.dennis.flaw.model.IssueStatusAddon;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.shared.entity.KeyValue;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.AddonComponent;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class IssueStatusModel
extends UserAssignableEntity
implements AddonComponent,
GroupableModel,
DemoModel {
    @MoveField
    private String name;
    @MoveField
    private String icon;
    @Column(columnDefinition="text")
    @MoveField
    private String description;
    @MoveField
    private String color;
    @ManyToOne(fetch=FetchType.LAZY)
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=GroupService.class)
    protected GroupModel group;
    @MoveField
    private Boolean isClosed = false;
    @MoveField
    private Integer statusHealth = -1;
    private Boolean demo = false;
    private String demoData;

    public String asValue() {
        return this.name;
    }

    public KeyValue defaultSearchOrderField() {
        return new KeyValue("name", (Object)Sort.Direction.ASC);
    }

    public Object getAddon() {
        return new IssueStatusAddon(this.icon, this.color);
    }

    public GroupModel findInnerGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getDescription() {
        return this.description;
    }

    public String getColor() {
        return this.color;
    }

    public GroupModel getGroup() {
        return this.group;
    }

    public Boolean getIsClosed() {
        return this.isClosed;
    }

    public Integer getStatusHealth() {
        return this.statusHealth;
    }

    public Boolean getDemo() {
        return this.demo;
    }

    public String getDemoData() {
        return this.demoData;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setGroup(GroupModel group) {
        this.group = group;
    }

    public void setIsClosed(Boolean isClosed) {
        this.isClosed = isClosed;
    }

    public void setStatusHealth(Integer statusHealth) {
        this.statusHealth = statusHealth;
    }

    public void setDemo(Boolean demo) {
        this.demo = demo;
    }

    public void setDemoData(String demoData) {
        this.demoData = demoData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IssueStatusModel)) {
            return false;
        }
        IssueStatusModel other = (IssueStatusModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$isClosed = this.getIsClosed();
        Boolean other$isClosed = other.getIsClosed();
        if (this$isClosed == null ? other$isClosed != null : !((Object)this$isClosed).equals(other$isClosed)) {
            return false;
        }
        Integer this$statusHealth = this.getStatusHealth();
        Integer other$statusHealth = other.getStatusHealth();
        if (this$statusHealth == null ? other$statusHealth != null : !((Object)this$statusHealth).equals(other$statusHealth)) {
            return false;
        }
        Boolean this$demo = this.getDemo();
        Boolean other$demo = other.getDemo();
        if (this$demo == null ? other$demo != null : !((Object)this$demo).equals(other$demo)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        GroupModel this$group = this.getGroup();
        GroupModel other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$demoData = this.getDemoData();
        String other$demoData = other.getDemoData();
        return !(this$demoData == null ? other$demoData != null : !this$demoData.equals(other$demoData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IssueStatusModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isClosed = this.getIsClosed();
        result = result * 59 + ($isClosed == null ? 43 : ((Object)$isClosed).hashCode());
        Integer $statusHealth = this.getStatusHealth();
        result = result * 59 + ($statusHealth == null ? 43 : ((Object)$statusHealth).hashCode());
        Boolean $demo = this.getDemo();
        result = result * 59 + ($demo == null ? 43 : ((Object)$demo).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        GroupModel $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $demoData = this.getDemoData();
        result = result * 59 + ($demoData == null ? 43 : $demoData.hashCode());
        return result;
    }

    public String toString() {
        return "IssueStatusModel(name=" + this.getName() + ", icon=" + this.getIcon() + ", description=" + this.getDescription() + ", color=" + this.getColor() + ", group=" + String.valueOf(this.getGroup()) + ", isClosed=" + this.getIsClosed() + ", statusHealth=" + this.getStatusHealth() + ", demo=" + this.getDemo() + ", demoData=" + this.getDemoData() + ")";
    }
}

