/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupableModel;
import systems.dennis.flaw.model.IssueLinkTypeModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.IssueLinkTypeService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class IssueToIssueLinkModel
extends UserAssignableEntity
implements GroupableModel {
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueLinkTypeService.class)
    private IssueLinkTypeModel linkType;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueService.class)
    private IssueModel parent;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueService.class)
    private IssueModel linked;
    @ManyToOne(fetch=FetchType.LAZY)
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=GroupService.class)
    protected GroupModel group;

    public GroupModel findInnerGroup() {
        return this.group;
    }

    public IssueLinkTypeModel getLinkType() {
        return this.linkType;
    }

    public IssueModel getParent() {
        return this.parent;
    }

    public IssueModel getLinked() {
        return this.linked;
    }

    public GroupModel getGroup() {
        return this.group;
    }

    public void setLinkType(IssueLinkTypeModel linkType) {
        this.linkType = linkType;
    }

    public void setParent(IssueModel parent) {
        this.parent = parent;
    }

    public void setLinked(IssueModel linked) {
        this.linked = linked;
    }

    public void setGroup(GroupModel group) {
        this.group = group;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IssueToIssueLinkModel)) {
            return false;
        }
        IssueToIssueLinkModel other = (IssueToIssueLinkModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        IssueLinkTypeModel this$linkType = this.getLinkType();
        IssueLinkTypeModel other$linkType = other.getLinkType();
        if (this$linkType == null ? other$linkType != null : !this$linkType.equals(other$linkType)) {
            return false;
        }
        IssueModel this$parent = this.getParent();
        IssueModel other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        IssueModel this$linked = this.getLinked();
        IssueModel other$linked = other.getLinked();
        if (this$linked == null ? other$linked != null : !this$linked.equals(other$linked)) {
            return false;
        }
        GroupModel this$group = this.getGroup();
        GroupModel other$group = other.getGroup();
        return !(this$group == null ? other$group != null : !this$group.equals(other$group));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IssueToIssueLinkModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IssueLinkTypeModel $linkType = this.getLinkType();
        result = result * 59 + ($linkType == null ? 43 : $linkType.hashCode());
        IssueModel $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        IssueModel $linked = this.getLinked();
        result = result * 59 + ($linked == null ? 43 : $linked.hashCode());
        GroupModel $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        return result;
    }

    public String toString() {
        return "IssueToIssueLinkModel(linkType=" + String.valueOf(this.getLinkType()) + ", parent=" + String.valueOf(this.getParent()) + ", linked=" + String.valueOf(this.getLinked()) + ", group=" + String.valueOf(this.getGroup()) + ")";
    }
}

