/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import java.util.Date;
import systems.dennis.flaw.model.ProjectModel;
import systems.dennis.flaw.model.ProjectStatusModel;
import systems.dennis.flaw.service.ProjectService;
import systems.dennis.flaw.service.ProjectStatusService;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class ProjectHistoryModel
extends UserAssignableEntity {
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=ProjectService.class)
    private ProjectModel project;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=ProjectStatusService.class)
    private ProjectStatusModel from;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=ProjectStatusService.class)
    private ProjectStatusModel to;
    @FormTransient
    @DataTransformer(transFormWith=DateAndStringConverter.class)
    private Date date = new Date();

    public ProjectModel getProject() {
        return this.project;
    }

    public ProjectStatusModel getFrom() {
        return this.from;
    }

    public ProjectStatusModel getTo() {
        return this.to;
    }

    public Date getDate() {
        return this.date;
    }

    public void setProject(ProjectModel project) {
        this.project = project;
    }

    public void setFrom(ProjectStatusModel from) {
        this.from = from;
    }

    public void setTo(ProjectStatusModel to) {
        this.to = to;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectHistoryModel)) {
            return false;
        }
        ProjectHistoryModel other = (ProjectHistoryModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ProjectModel this$project = this.getProject();
        ProjectModel other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        ProjectStatusModel this$from = this.getFrom();
        ProjectStatusModel other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        ProjectStatusModel this$to = this.getTo();
        ProjectStatusModel other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectHistoryModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProjectModel $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        ProjectStatusModel $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        ProjectStatusModel $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }

    public String toString() {
        return "ProjectHistoryModel(project=" + String.valueOf(this.getProject()) + ", from=" + String.valueOf(this.getFrom()) + ", to=" + String.valueOf(this.getTo()) + ", date=" + String.valueOf(this.getDate()) + ")";
    }
}

