/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import java.util.Date;
import systems.dennis.flaw.annotation.MoveField;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupableModel;
import systems.dennis.flaw.model.Iconable;
import systems.dennis.flaw.model.ImportModel;
import systems.dennis.flaw.model.ProjectFlowModel;
import systems.dennis.flaw.model.ProjectStatusModel;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.ProjectFlowService;
import systems.dennis.flaw.service.ProjectStatusService;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class ProjectModel
extends ImportModel
implements Iconable,
GroupableModel {
    @MoveField
    private String name;
    @MoveField
    private String icon;
    @Column(columnDefinition="text")
    @MoveField
    private String description;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=ProjectStatusService.class)
    @MoveField
    private ProjectStatusModel status;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=ProjectFlowService.class)
    @MoveField(createPolicy=2)
    private ProjectFlowModel projectFlow;
    @FormTransient
    @DataTransformer(transFormWith=DateAndStringConverter.class, params={"dd.MM.yyyy"})
    @MoveField
    private Date created;
    @DataTransformer(transFormWith=DateAndStringConverter.class, params={"dd.MM.yyyy"})
    @MoveField
    private Date start;
    @DataTransformer(transFormWith=DateAndStringConverter.class, params={"dd.MM.yyyy"})
    @Column(name="project_end")
    @MoveField
    private Date end;
    @ManyToOne(fetch=FetchType.LAZY)
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=GroupService.class)
    private GroupModel group;

    public String asValue() {
        return this.name;
    }

    public GroupModel findInnerGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getDescription() {
        return this.description;
    }

    public ProjectStatusModel getStatus() {
        return this.status;
    }

    public ProjectFlowModel getProjectFlow() {
        return this.projectFlow;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public GroupModel getGroup() {
        return this.group;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStatus(ProjectStatusModel status) {
        this.status = status;
    }

    public void setProjectFlow(ProjectFlowModel projectFlow) {
        this.projectFlow = projectFlow;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public void setGroup(GroupModel group) {
        this.group = group;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectModel)) {
            return false;
        }
        ProjectModel other = (ProjectModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ProjectStatusModel this$status = this.getStatus();
        ProjectStatusModel other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        ProjectFlowModel this$projectFlow = this.getProjectFlow();
        ProjectFlowModel other$projectFlow = other.getProjectFlow();
        if (this$projectFlow == null ? other$projectFlow != null : !this$projectFlow.equals(other$projectFlow)) {
            return false;
        }
        Date this$created = this.getCreated();
        Date other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Date this$start = this.getStart();
        Date other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Date this$end = this.getEnd();
        Date other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        GroupModel this$group = this.getGroup();
        GroupModel other$group = other.getGroup();
        return !(this$group == null ? other$group != null : !this$group.equals(other$group));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ProjectStatusModel $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        ProjectFlowModel $projectFlow = this.getProjectFlow();
        result = result * 59 + ($projectFlow == null ? 43 : $projectFlow.hashCode());
        Date $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Date $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Date $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        GroupModel $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        return result;
    }

    public String toString() {
        return "ProjectModel(name=" + this.getName() + ", icon=" + this.getIcon() + ", description=" + this.getDescription() + ", status=" + String.valueOf(this.getStatus()) + ", projectFlow=" + String.valueOf(this.getProjectFlow()) + ", created=" + String.valueOf(this.getCreated()) + ", start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + ", group=" + String.valueOf(this.getGroup()) + ")";
    }
}

