/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import java.util.Date;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupableModel;
import systems.dennis.flaw.model.ProjectModel;
import systems.dennis.flaw.service.ProjectService;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class ProjectVersionModel
extends UserAssignableEntity
implements GroupableModel {
    private String name;
    @Column(columnDefinition="text")
    private String description;
    @Column(columnDefinition="text")
    private String changes;
    @DataTransformer(transFormWith=DateAndStringConverter.class)
    private Date plannedRelease;
    @DataTransformer(transFormWith=DateAndStringConverter.class)
    private Date factRelease;
    @ManyToOne(fetch=FetchType.LAZY)
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=ProjectService.class)
    private ProjectModel project;
    @ManyToOne(fetch=FetchType.LAZY)
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=GroupModel.class)
    private GroupModel group;
    private String icon;

    public GroupModel findInnerGroup() {
        if (this.project == null) {
            return null;
        }
        return this.project.getGroup();
    }

    public GroupModel getGroup() {
        return this.findInnerGroup();
    }

    public String asValue() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getChanges() {
        return this.changes;
    }

    public Date getPlannedRelease() {
        return this.plannedRelease;
    }

    public Date getFactRelease() {
        return this.factRelease;
    }

    public ProjectModel getProject() {
        return this.project;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setChanges(String changes) {
        this.changes = changes;
    }

    public void setPlannedRelease(Date plannedRelease) {
        this.plannedRelease = plannedRelease;
    }

    public void setFactRelease(Date factRelease) {
        this.factRelease = factRelease;
    }

    public void setProject(ProjectModel project) {
        this.project = project;
    }

    public void setGroup(GroupModel group) {
        this.group = group;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectVersionModel)) {
            return false;
        }
        ProjectVersionModel other = (ProjectVersionModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$changes = this.getChanges();
        String other$changes = other.getChanges();
        if (this$changes == null ? other$changes != null : !this$changes.equals(other$changes)) {
            return false;
        }
        Date this$plannedRelease = this.getPlannedRelease();
        Date other$plannedRelease = other.getPlannedRelease();
        if (this$plannedRelease == null ? other$plannedRelease != null : !((Object)this$plannedRelease).equals(other$plannedRelease)) {
            return false;
        }
        Date this$factRelease = this.getFactRelease();
        Date other$factRelease = other.getFactRelease();
        if (this$factRelease == null ? other$factRelease != null : !((Object)this$factRelease).equals(other$factRelease)) {
            return false;
        }
        ProjectModel this$project = this.getProject();
        ProjectModel other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        GroupModel this$group = this.getGroup();
        GroupModel other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        return !(this$icon == null ? other$icon != null : !this$icon.equals(other$icon));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectVersionModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $changes = this.getChanges();
        result = result * 59 + ($changes == null ? 43 : $changes.hashCode());
        Date $plannedRelease = this.getPlannedRelease();
        result = result * 59 + ($plannedRelease == null ? 43 : ((Object)$plannedRelease).hashCode());
        Date $factRelease = this.getFactRelease();
        result = result * 59 + ($factRelease == null ? 43 : ((Object)$factRelease).hashCode());
        ProjectModel $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        GroupModel $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        return result;
    }

    public String toString() {
        return "ProjectVersionModel(name=" + this.getName() + ", description=" + this.getDescription() + ", changes=" + this.getChanges() + ", plannedRelease=" + String.valueOf(this.getPlannedRelease()) + ", factRelease=" + String.valueOf(this.getFactRelease()) + ", project=" + String.valueOf(this.getProject()) + ", group=" + String.valueOf(this.getGroup()) + ", icon=" + this.getIcon() + ")";
    }
}

