/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import java.util.Date;
import systems.dennis.flaw.model.CurrencyModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.service.CurrencyService;
import systems.dennis.flaw.service.HRService;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class SalaryModel
extends UserAssignableEntity {
    private Long amount;
    @OneToOne
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=CurrencyService.class)
    private CurrencyModel currency;
    @OneToOne
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=HRService.class)
    private HRModel hr;
    @DataTransformer(transFormWith=DateAndStringConverter.class, params={"dd.MM.yyyy"})
    private Date since;
    private String limitFormula;
    private Integer type;

    public Long getAmount() {
        return this.amount;
    }

    public CurrencyModel getCurrency() {
        return this.currency;
    }

    public HRModel getHr() {
        return this.hr;
    }

    public Date getSince() {
        return this.since;
    }

    public String getLimitFormula() {
        return this.limitFormula;
    }

    public Integer getType() {
        return this.type;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public void setCurrency(CurrencyModel currency) {
        this.currency = currency;
    }

    public void setHr(HRModel hr) {
        this.hr = hr;
    }

    public void setSince(Date since) {
        this.since = since;
    }

    public void setLimitFormula(String limitFormula) {
        this.limitFormula = limitFormula;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SalaryModel)) {
            return false;
        }
        SalaryModel other = (SalaryModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        CurrencyModel this$currency = this.getCurrency();
        CurrencyModel other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        HRModel this$hr = this.getHr();
        HRModel other$hr = other.getHr();
        if (this$hr == null ? other$hr != null : !this$hr.equals(other$hr)) {
            return false;
        }
        Date this$since = this.getSince();
        Date other$since = other.getSince();
        if (this$since == null ? other$since != null : !((Object)this$since).equals(other$since)) {
            return false;
        }
        String this$limitFormula = this.getLimitFormula();
        String other$limitFormula = other.getLimitFormula();
        return !(this$limitFormula == null ? other$limitFormula != null : !this$limitFormula.equals(other$limitFormula));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SalaryModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        CurrencyModel $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        HRModel $hr = this.getHr();
        result = result * 59 + ($hr == null ? 43 : $hr.hashCode());
        Date $since = this.getSince();
        result = result * 59 + ($since == null ? 43 : ((Object)$since).hashCode());
        String $limitFormula = this.getLimitFormula();
        result = result * 59 + ($limitFormula == null ? 43 : $limitFormula.hashCode());
        return result;
    }

    public String toString() {
        return "SalaryModel(amount=" + this.getAmount() + ", currency=" + String.valueOf(this.getCurrency()) + ", hr=" + String.valueOf(this.getHr()) + ", since=" + String.valueOf(this.getSince()) + ", limitFormula=" + this.getLimitFormula() + ", type=" + this.getType() + ")";
    }
}

