/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import java.util.Date;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.SprintModel;
import systems.dennis.flaw.model.SprintStatusModel;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.SprintStatusService;
import systems.dennis.flaw.service.sprint.SprintService;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class SprintHistoryModel
extends UserAssignableEntity {
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=SprintService.class)
    private SprintModel sprint;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=SprintStatusService.class)
    private SprintStatusModel from;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=SprintStatusService.class)
    private SprintStatusModel to;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=HRService.class)
    private HRModel performer;
    @FormTransient
    @DataTransformer(transFormWith=DateAndStringConverter.class)
    private Date date = new Date();

    public SprintModel getSprint() {
        return this.sprint;
    }

    public SprintStatusModel getFrom() {
        return this.from;
    }

    public SprintStatusModel getTo() {
        return this.to;
    }

    public HRModel getPerformer() {
        return this.performer;
    }

    public Date getDate() {
        return this.date;
    }

    public void setSprint(SprintModel sprint) {
        this.sprint = sprint;
    }

    public void setFrom(SprintStatusModel from) {
        this.from = from;
    }

    public void setTo(SprintStatusModel to) {
        this.to = to;
    }

    public void setPerformer(HRModel performer) {
        this.performer = performer;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SprintHistoryModel)) {
            return false;
        }
        SprintHistoryModel other = (SprintHistoryModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        SprintModel this$sprint = this.getSprint();
        SprintModel other$sprint = other.getSprint();
        if (this$sprint == null ? other$sprint != null : !this$sprint.equals(other$sprint)) {
            return false;
        }
        SprintStatusModel this$from = this.getFrom();
        SprintStatusModel other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        SprintStatusModel this$to = this.getTo();
        SprintStatusModel other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        HRModel this$performer = this.getPerformer();
        HRModel other$performer = other.getPerformer();
        if (this$performer == null ? other$performer != null : !this$performer.equals(other$performer)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SprintHistoryModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SprintModel $sprint = this.getSprint();
        result = result * 59 + ($sprint == null ? 43 : $sprint.hashCode());
        SprintStatusModel $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        SprintStatusModel $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        HRModel $performer = this.getPerformer();
        result = result * 59 + ($performer == null ? 43 : $performer.hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }

    public String toString() {
        return "SprintHistoryModel(sprint=" + String.valueOf(this.getSprint()) + ", from=" + String.valueOf(this.getFrom()) + ", to=" + String.valueOf(this.getTo()) + ", performer=" + String.valueOf(this.getPerformer()) + ", date=" + String.valueOf(this.getDate()) + ")";
    }
}

