/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import java.util.Date;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupableModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.ProjectModel;
import systems.dennis.flaw.model.ProjectVersionModel;
import systems.dennis.flaw.model.SprintFlowModel;
import systems.dennis.flaw.model.SprintStatusModel;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.ProjectService;
import systems.dennis.flaw.service.ProjectVersionService;
import systems.dennis.flaw.service.SprintFlowService;
import systems.dennis.flaw.service.SprintStatusService;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class SprintModel
extends UserAssignableEntity
implements GroupableModel {
    @OneToOne
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=GroupService.class)
    private GroupModel group;
    @OneToOne
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=ProjectVersionService.class)
    private ProjectVersionModel projectVersion;
    @Column(columnDefinition="text")
    private String description;
    @OneToOne
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=SprintStatusService.class)
    private SprintStatusModel status;
    @OneToOne
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=SprintStatusService.class)
    private SprintStatusModel all_tasks_status;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=SprintFlowService.class)
    private SprintFlowModel sprintFlow;
    @OneToOne
    @ObjectByIdPresentation
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=ProjectService.class)
    private ProjectModel project;
    @OneToOne
    @FormTransient
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=HRService.class)
    private HRModel creator;
    @DataTransformer(transFormWith=DateAndStringConverter.class, params={"dd.MM.yyyy"})
    private Date start;
    @DataTransformer(transFormWith=DateAndStringConverter.class, params={"dd.MM.yyyy"})
    private Date finishedOn;
    @DataTransformer(transFormWith=DateAndStringConverter.class, params={"dd.MM.yyyy"})
    private Date finish;

    public String asValue() {
        return this.description;
    }

    public GroupModel findInnerGroup() {
        if (this.project != null) {
            return this.project.getGroup();
        }
        return this.group;
    }

    public GroupModel getGroup() {
        return this.group;
    }

    public ProjectVersionModel getProjectVersion() {
        return this.projectVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public SprintStatusModel getStatus() {
        return this.status;
    }

    public SprintStatusModel getAll_tasks_status() {
        return this.all_tasks_status;
    }

    public SprintFlowModel getSprintFlow() {
        return this.sprintFlow;
    }

    public ProjectModel getProject() {
        return this.project;
    }

    public HRModel getCreator() {
        return this.creator;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getFinishedOn() {
        return this.finishedOn;
    }

    public Date getFinish() {
        return this.finish;
    }

    public void setGroup(GroupModel group) {
        this.group = group;
    }

    public void setProjectVersion(ProjectVersionModel projectVersion) {
        this.projectVersion = projectVersion;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStatus(SprintStatusModel status) {
        this.status = status;
    }

    public void setAll_tasks_status(SprintStatusModel all_tasks_status) {
        this.all_tasks_status = all_tasks_status;
    }

    public void setSprintFlow(SprintFlowModel sprintFlow) {
        this.sprintFlow = sprintFlow;
    }

    public void setProject(ProjectModel project) {
        this.project = project;
    }

    public void setCreator(HRModel creator) {
        this.creator = creator;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public void setFinishedOn(Date finishedOn) {
        this.finishedOn = finishedOn;
    }

    public void setFinish(Date finish) {
        this.finish = finish;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SprintModel)) {
            return false;
        }
        SprintModel other = (SprintModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        GroupModel this$group = this.getGroup();
        GroupModel other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        ProjectVersionModel this$projectVersion = this.getProjectVersion();
        ProjectVersionModel other$projectVersion = other.getProjectVersion();
        if (this$projectVersion == null ? other$projectVersion != null : !this$projectVersion.equals(other$projectVersion)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        SprintStatusModel this$status = this.getStatus();
        SprintStatusModel other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        SprintStatusModel this$all_tasks_status = this.getAll_tasks_status();
        SprintStatusModel other$all_tasks_status = other.getAll_tasks_status();
        if (this$all_tasks_status == null ? other$all_tasks_status != null : !this$all_tasks_status.equals(other$all_tasks_status)) {
            return false;
        }
        SprintFlowModel this$sprintFlow = this.getSprintFlow();
        SprintFlowModel other$sprintFlow = other.getSprintFlow();
        if (this$sprintFlow == null ? other$sprintFlow != null : !this$sprintFlow.equals(other$sprintFlow)) {
            return false;
        }
        ProjectModel this$project = this.getProject();
        ProjectModel other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        HRModel this$creator = this.getCreator();
        HRModel other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        Date this$start = this.getStart();
        Date other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Date this$finishedOn = this.getFinishedOn();
        Date other$finishedOn = other.getFinishedOn();
        if (this$finishedOn == null ? other$finishedOn != null : !((Object)this$finishedOn).equals(other$finishedOn)) {
            return false;
        }
        Date this$finish = this.getFinish();
        Date other$finish = other.getFinish();
        return !(this$finish == null ? other$finish != null : !((Object)this$finish).equals(other$finish));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SprintModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GroupModel $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        ProjectVersionModel $projectVersion = this.getProjectVersion();
        result = result * 59 + ($projectVersion == null ? 43 : $projectVersion.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        SprintStatusModel $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        SprintStatusModel $all_tasks_status = this.getAll_tasks_status();
        result = result * 59 + ($all_tasks_status == null ? 43 : $all_tasks_status.hashCode());
        SprintFlowModel $sprintFlow = this.getSprintFlow();
        result = result * 59 + ($sprintFlow == null ? 43 : $sprintFlow.hashCode());
        ProjectModel $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        HRModel $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        Date $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Date $finishedOn = this.getFinishedOn();
        result = result * 59 + ($finishedOn == null ? 43 : ((Object)$finishedOn).hashCode());
        Date $finish = this.getFinish();
        result = result * 59 + ($finish == null ? 43 : ((Object)$finish).hashCode());
        return result;
    }

    public String toString() {
        return "SprintModel(group=" + String.valueOf(this.getGroup()) + ", projectVersion=" + String.valueOf(this.getProjectVersion()) + ", description=" + this.getDescription() + ", status=" + String.valueOf(this.getStatus()) + ", all_tasks_status=" + String.valueOf(this.getAll_tasks_status()) + ", sprintFlow=" + String.valueOf(this.getSprintFlow()) + ", project=" + String.valueOf(this.getProject()) + ", creator=" + String.valueOf(this.getCreator()) + ", start=" + String.valueOf(this.getStart()) + ", finishedOn=" + String.valueOf(this.getFinishedOn()) + ", finish=" + String.valueOf(this.getFinish()) + ")";
    }
}

