/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import java.util.Date;
import systems.dennis.flaw.annotation.MoveField;
import systems.dennis.flaw.model.EpicModel;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupableModel;
import systems.dennis.flaw.model.ProjectModel;
import systems.dennis.flaw.model.StoryFlowModel;
import systems.dennis.flaw.model.StoryStatusModel;
import systems.dennis.flaw.service.EpicService;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.ProjectService;
import systems.dennis.flaw.service.StoryFlowService;
import systems.dennis.flaw.service.StoryService;
import systems.dennis.flaw.service.StoryStatusService;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class StoryModel
extends UserAssignableEntity
implements GroupableModel {
    @MoveField
    private String name;
    @DataTransformer(transFormWith=DateAndStringConverter.class)
    @MoveField
    private Date start;
    @DataTransformer(transFormWith=DateAndStringConverter.class)
    @MoveField
    private Date finish;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=StoryService.class)
    @MoveField
    private StoryModel nextStory;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=StoryStatusService.class)
    @MoveField
    private StoryStatusModel status;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=EpicService.class)
    @MoveField
    private EpicModel epic;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=GroupService.class)
    private GroupModel group;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=ProjectService.class)
    @MoveField
    private ProjectModel project;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=StoryFlowService.class)
    @MoveField(createPolicy=2)
    private StoryFlowModel storyFlow;

    public String asValue() {
        return this.name;
    }

    public GroupModel findInnerGroup() {
        if (this.epic != null) {
            return this.epic.getGroup();
        }
        if (this.project != null) {
            return this.project.getGroup();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getFinish() {
        return this.finish;
    }

    public StoryModel getNextStory() {
        return this.nextStory;
    }

    public StoryStatusModel getStatus() {
        return this.status;
    }

    public EpicModel getEpic() {
        return this.epic;
    }

    public GroupModel getGroup() {
        return this.group;
    }

    public ProjectModel getProject() {
        return this.project;
    }

    public StoryFlowModel getStoryFlow() {
        return this.storyFlow;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public void setFinish(Date finish) {
        this.finish = finish;
    }

    public void setNextStory(StoryModel nextStory) {
        this.nextStory = nextStory;
    }

    public void setStatus(StoryStatusModel status) {
        this.status = status;
    }

    public void setEpic(EpicModel epic) {
        this.epic = epic;
    }

    public void setGroup(GroupModel group) {
        this.group = group;
    }

    public void setProject(ProjectModel project) {
        this.project = project;
    }

    public void setStoryFlow(StoryFlowModel storyFlow) {
        this.storyFlow = storyFlow;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoryModel)) {
            return false;
        }
        StoryModel other = (StoryModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Date this$start = this.getStart();
        Date other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Date this$finish = this.getFinish();
        Date other$finish = other.getFinish();
        if (this$finish == null ? other$finish != null : !((Object)this$finish).equals(other$finish)) {
            return false;
        }
        StoryModel this$nextStory = this.getNextStory();
        StoryModel other$nextStory = other.getNextStory();
        if (this$nextStory == null ? other$nextStory != null : !this$nextStory.equals(other$nextStory)) {
            return false;
        }
        StoryStatusModel this$status = this.getStatus();
        StoryStatusModel other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        EpicModel this$epic = this.getEpic();
        EpicModel other$epic = other.getEpic();
        if (this$epic == null ? other$epic != null : !this$epic.equals(other$epic)) {
            return false;
        }
        GroupModel this$group = this.getGroup();
        GroupModel other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        ProjectModel this$project = this.getProject();
        ProjectModel other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        StoryFlowModel this$storyFlow = this.getStoryFlow();
        StoryFlowModel other$storyFlow = other.getStoryFlow();
        return !(this$storyFlow == null ? other$storyFlow != null : !this$storyFlow.equals(other$storyFlow));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StoryModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Date $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Date $finish = this.getFinish();
        result = result * 59 + ($finish == null ? 43 : ((Object)$finish).hashCode());
        StoryModel $nextStory = this.getNextStory();
        result = result * 59 + ($nextStory == null ? 43 : $nextStory.hashCode());
        StoryStatusModel $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        EpicModel $epic = this.getEpic();
        result = result * 59 + ($epic == null ? 43 : $epic.hashCode());
        GroupModel $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        ProjectModel $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        StoryFlowModel $storyFlow = this.getStoryFlow();
        result = result * 59 + ($storyFlow == null ? 43 : $storyFlow.hashCode());
        return result;
    }

    public String toString() {
        return "StoryModel(name=" + this.getName() + ", start=" + String.valueOf(this.getStart()) + ", finish=" + String.valueOf(this.getFinish()) + ", nextStory=" + String.valueOf(this.getNextStory()) + ", status=" + String.valueOf(this.getStatus()) + ", epic=" + String.valueOf(this.getEpic()) + ", group=" + String.valueOf(this.getGroup()) + ", project=" + String.valueOf(this.getProject()) + ", storyFlow=" + String.valueOf(this.getStoryFlow()) + ")";
    }
}

