/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import systems.dennis.flaw.model.ChecklistModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.model.TestStatusModel;
import systems.dennis.flaw.service.ChecklistService;
import systems.dennis.flaw.service.TestStatusService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class TestResultModel
extends UserAssignableEntity {
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueService.class)
    private IssueModel issue;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=TestStatusService.class)
    private TestStatusModel testStatus;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=ChecklistService.class)
    private ChecklistModel checklist;

    public IssueModel getIssue() {
        return this.issue;
    }

    public TestStatusModel getTestStatus() {
        return this.testStatus;
    }

    public ChecklistModel getChecklist() {
        return this.checklist;
    }

    public void setIssue(IssueModel issue) {
        this.issue = issue;
    }

    public void setTestStatus(TestStatusModel testStatus) {
        this.testStatus = testStatus;
    }

    public void setChecklist(ChecklistModel checklist) {
        this.checklist = checklist;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestResultModel)) {
            return false;
        }
        TestResultModel other = (TestResultModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        IssueModel this$issue = this.getIssue();
        IssueModel other$issue = other.getIssue();
        if (this$issue == null ? other$issue != null : !this$issue.equals(other$issue)) {
            return false;
        }
        TestStatusModel this$testStatus = this.getTestStatus();
        TestStatusModel other$testStatus = other.getTestStatus();
        if (this$testStatus == null ? other$testStatus != null : !this$testStatus.equals(other$testStatus)) {
            return false;
        }
        ChecklistModel this$checklist = this.getChecklist();
        ChecklistModel other$checklist = other.getChecklist();
        return !(this$checklist == null ? other$checklist != null : !this$checklist.equals(other$checklist));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestResultModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IssueModel $issue = this.getIssue();
        result = result * 59 + ($issue == null ? 43 : $issue.hashCode());
        TestStatusModel $testStatus = this.getTestStatus();
        result = result * 59 + ($testStatus == null ? 43 : $testStatus.hashCode());
        ChecklistModel $checklist = this.getChecklist();
        result = result * 59 + ($checklist == null ? 43 : $checklist.hashCode());
        return result;
    }

    public String toString() {
        return "TestResultModel(issue=" + String.valueOf(this.getIssue()) + ", testStatus=" + String.valueOf(this.getTestStatus()) + ", checklist=" + String.valueOf(this.getChecklist()) + ")";
    }
}

