/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import java.util.Date;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class ViewerModel
extends UserAssignableEntity {
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueService.class)
    private IssueModel issue;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=HRService.class)
    private HRModel hr;
    @FormTransient
    @DataTransformer(transFormWith=DateAndStringConverter.class, params={"dd.MM.yyyy"})
    private Date created;

    public IssueModel getIssue() {
        return this.issue;
    }

    public HRModel getHr() {
        return this.hr;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setIssue(IssueModel issue) {
        this.issue = issue;
    }

    public void setHr(HRModel hr) {
        this.hr = hr;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewerModel)) {
            return false;
        }
        ViewerModel other = (ViewerModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        IssueModel this$issue = this.getIssue();
        IssueModel other$issue = other.getIssue();
        if (this$issue == null ? other$issue != null : !this$issue.equals(other$issue)) {
            return false;
        }
        HRModel this$hr = this.getHr();
        HRModel other$hr = other.getHr();
        if (this$hr == null ? other$hr != null : !this$hr.equals(other$hr)) {
            return false;
        }
        Date this$created = this.getCreated();
        Date other$created = other.getCreated();
        return !(this$created == null ? other$created != null : !((Object)this$created).equals(other$created));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ViewerModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IssueModel $issue = this.getIssue();
        result = result * 59 + ($issue == null ? 43 : $issue.hashCode());
        HRModel $hr = this.getHr();
        result = result * 59 + ($hr == null ? 43 : $hr.hashCode());
        Date $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        return result;
    }

    public String toString() {
        return "ViewerModel(issue=" + String.valueOf(this.getIssue()) + ", hr=" + String.valueOf(this.getHr()) + ", created=" + String.valueOf(this.getCreated()) + ")";
    }
}

