/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import java.util.Date;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupableModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.model.ProjectModel;
import systems.dennis.flaw.model.WorkingCalendarModel;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.ProjectService;
import systems.dennis.flaw.service.WorkingCalendarService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class WorkLogModel
extends UserAssignableEntity
implements GroupableModel {
    private Integer amount;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=GroupService.class)
    private GroupModel group;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueService.class)
    private IssueModel issue;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=HRModel.class)
    private HRModel hr;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=ProjectService.class)
    private ProjectModel project;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=WorkingCalendarService.class)
    private WorkingCalendarModel calendarModel;
    @DataTransformer(transFormWith=DateAndStringConverter.class)
    private Date date;
    @Column(columnDefinition="text")
    private String description;
    private Boolean idleTime;

    public GroupModel findInnerGroup() {
        if (this.getProject() != null) {
            return this.project.getGroup();
        }
        if (this.getIssue() != null) {
            return this.issue.getGroup();
        }
        return this.project.getGroup();
    }

    public Integer getAmount() {
        return this.amount;
    }

    public GroupModel getGroup() {
        return this.group;
    }

    public IssueModel getIssue() {
        return this.issue;
    }

    public HRModel getHr() {
        return this.hr;
    }

    public ProjectModel getProject() {
        return this.project;
    }

    public WorkingCalendarModel getCalendarModel() {
        return this.calendarModel;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIdleTime() {
        return this.idleTime;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public void setGroup(GroupModel group) {
        this.group = group;
    }

    public void setIssue(IssueModel issue) {
        this.issue = issue;
    }

    public void setHr(HRModel hr) {
        this.hr = hr;
    }

    public void setProject(ProjectModel project) {
        this.project = project;
    }

    public void setCalendarModel(WorkingCalendarModel calendarModel) {
        this.calendarModel = calendarModel;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIdleTime(Boolean idleTime) {
        this.idleTime = idleTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkLogModel)) {
            return false;
        }
        WorkLogModel other = (WorkLogModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$amount = this.getAmount();
        Integer other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Boolean this$idleTime = this.getIdleTime();
        Boolean other$idleTime = other.getIdleTime();
        if (this$idleTime == null ? other$idleTime != null : !((Object)this$idleTime).equals(other$idleTime)) {
            return false;
        }
        GroupModel this$group = this.getGroup();
        GroupModel other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        IssueModel this$issue = this.getIssue();
        IssueModel other$issue = other.getIssue();
        if (this$issue == null ? other$issue != null : !this$issue.equals(other$issue)) {
            return false;
        }
        HRModel this$hr = this.getHr();
        HRModel other$hr = other.getHr();
        if (this$hr == null ? other$hr != null : !this$hr.equals(other$hr)) {
            return false;
        }
        ProjectModel this$project = this.getProject();
        ProjectModel other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        WorkingCalendarModel this$calendarModel = this.getCalendarModel();
        WorkingCalendarModel other$calendarModel = other.getCalendarModel();
        if (this$calendarModel == null ? other$calendarModel != null : !this$calendarModel.equals(other$calendarModel)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkLogModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Boolean $idleTime = this.getIdleTime();
        result = result * 59 + ($idleTime == null ? 43 : ((Object)$idleTime).hashCode());
        GroupModel $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        IssueModel $issue = this.getIssue();
        result = result * 59 + ($issue == null ? 43 : $issue.hashCode());
        HRModel $hr = this.getHr();
        result = result * 59 + ($hr == null ? 43 : $hr.hashCode());
        ProjectModel $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        WorkingCalendarModel $calendarModel = this.getCalendarModel();
        result = result * 59 + ($calendarModel == null ? 43 : $calendarModel.hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "WorkLogModel(amount=" + this.getAmount() + ", group=" + String.valueOf(this.getGroup()) + ", issue=" + String.valueOf(this.getIssue()) + ", hr=" + String.valueOf(this.getHr()) + ", project=" + String.valueOf(this.getProject()) + ", calendarModel=" + String.valueOf(this.getCalendarModel()) + ", date=" + String.valueOf(this.getDate()) + ", description=" + this.getDescription() + ", idleTime=" + this.getIdleTime() + ")";
    }
}

