/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import java.util.List;
import systems.dennis.flaw.model.DayItems;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupableModel;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class WorkingCalendarModel
extends UserAssignableEntity
implements GroupableModel {
    public static final int CREATED = 1;
    public static final int IN_USE = 2;
    public static final int CLOSED = 3;
    private String name;
    private Integer year;
    private Integer month;
    private Integer hoursInMonth;
    @OneToMany(cascade={CascadeType.ALL})
    private List<DayItems> days;
    private Integer type = 1;
    @ManyToOne(fetch=FetchType.LAZY)
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=GroupService.class)
    protected GroupModel group;

    public String asValue() {
        return this.month + "." + this.year + " [" + this.hoursInMonth + "]";
    }

    public GroupModel findInnerGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public Integer getYear() {
        return this.year;
    }

    public Integer getMonth() {
        return this.month;
    }

    public Integer getHoursInMonth() {
        return this.hoursInMonth;
    }

    public List<DayItems> getDays() {
        return this.days;
    }

    public Integer getType() {
        return this.type;
    }

    public GroupModel getGroup() {
        return this.group;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }

    public void setHoursInMonth(Integer hoursInMonth) {
        this.hoursInMonth = hoursInMonth;
    }

    public void setDays(List<DayItems> days) {
        this.days = days;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setGroup(GroupModel group) {
        this.group = group;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkingCalendarModel)) {
            return false;
        }
        WorkingCalendarModel other = (WorkingCalendarModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$year = this.getYear();
        Integer other$year = other.getYear();
        if (this$year == null ? other$year != null : !((Object)this$year).equals(other$year)) {
            return false;
        }
        Integer this$month = this.getMonth();
        Integer other$month = other.getMonth();
        if (this$month == null ? other$month != null : !((Object)this$month).equals(other$month)) {
            return false;
        }
        Integer this$hoursInMonth = this.getHoursInMonth();
        Integer other$hoursInMonth = other.getHoursInMonth();
        if (this$hoursInMonth == null ? other$hoursInMonth != null : !((Object)this$hoursInMonth).equals(other$hoursInMonth)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List this$days = this.getDays();
        List other$days = other.getDays();
        if (this$days == null ? other$days != null : !((Object)this$days).equals(other$days)) {
            return false;
        }
        GroupModel this$group = this.getGroup();
        GroupModel other$group = other.getGroup();
        return !(this$group == null ? other$group != null : !this$group.equals(other$group));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkingCalendarModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $year = this.getYear();
        result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
        Integer $month = this.getMonth();
        result = result * 59 + ($month == null ? 43 : ((Object)$month).hashCode());
        Integer $hoursInMonth = this.getHoursInMonth();
        result = result * 59 + ($hoursInMonth == null ? 43 : ((Object)$hoursInMonth).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List $days = this.getDays();
        result = result * 59 + ($days == null ? 43 : ((Object)$days).hashCode());
        GroupModel $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        return result;
    }

    public String toString() {
        return "WorkingCalendarModel(name=" + this.getName() + ", year=" + this.getYear() + ", month=" + this.getMonth() + ", hoursInMonth=" + this.getHoursInMonth() + ", days=" + String.valueOf(this.getDays()) + ", type=" + this.getType() + ", group=" + String.valueOf(this.getGroup()) + ")";
    }
}

