/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.model.personal_working_time;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToOne;
import java.util.Date;
import systems.dennis.flaw.model.EpicModel;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupableModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.model.ProjectModel;
import systems.dennis.flaw.model.StoryModel;
import systems.dennis.flaw.service.EpicService;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.ProjectService;
import systems.dennis.flaw.service.StoryService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.model.UserAssignableEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
public class WorkingTimeModel
extends UserAssignableEntity
implements GroupableModel {
    @DataTransformer(transFormWith=DateAndStringConverter.class, params={"dd.MM.yyyy"})
    private Date date;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=HRService.class)
    private HRModel person;
    private Integer minutes;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=GroupService.class)
    private GroupModel group;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=ProjectService.class)
    private ProjectModel project;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=EpicService.class)
    private EpicModel epic;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=StoryService.class)
    private StoryModel story;
    @OneToOne
    @DataTransformer(transFormWith=IdToObjectTransformer.class, additionalClass=IssueService.class)
    private IssueModel issue;
    @Column(columnDefinition="text")
    private String description;

    public GroupModel findInnerGroup() {
        if (this.issue != null) {
            return this.issue.getGroup();
        }
        if (this.story != null) {
            return this.story.getGroup();
        }
        if (this.epic != null) {
            return this.epic.getGroup();
        }
        if (this.project != null) {
            return this.project.getGroup();
        }
        return null;
    }

    public ProjectModel findInnerProject() {
        if (this.issue != null) {
            return this.issue.getProject();
        }
        if (this.story != null) {
            return this.story.getProject();
        }
        if (this.epic != null) {
            return this.epic.getProject();
        }
        return null;
    }

    public EpicModel findInnerEpic() {
        if (this.issue != null) {
            return this.issue.getEpic();
        }
        if (this.story != null) {
            return this.story.getEpic();
        }
        return null;
    }

    public StoryModel findInnerStory() {
        if (this.issue != null) {
            return this.issue.getStory();
        }
        return null;
    }

    public Date getDate() {
        return this.date;
    }

    public HRModel getPerson() {
        return this.person;
    }

    public Integer getMinutes() {
        return this.minutes;
    }

    public GroupModel getGroup() {
        return this.group;
    }

    public ProjectModel getProject() {
        return this.project;
    }

    public EpicModel getEpic() {
        return this.epic;
    }

    public StoryModel getStory() {
        return this.story;
    }

    public IssueModel getIssue() {
        return this.issue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setPerson(HRModel person) {
        this.person = person;
    }

    public void setMinutes(Integer minutes) {
        this.minutes = minutes;
    }

    public void setGroup(GroupModel group) {
        this.group = group;
    }

    public void setProject(ProjectModel project) {
        this.project = project;
    }

    public void setEpic(EpicModel epic) {
        this.epic = epic;
    }

    public void setStory(StoryModel story) {
        this.story = story;
    }

    public void setIssue(IssueModel issue) {
        this.issue = issue;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkingTimeModel)) {
            return false;
        }
        WorkingTimeModel other = (WorkingTimeModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$minutes = this.getMinutes();
        Integer other$minutes = other.getMinutes();
        if (this$minutes == null ? other$minutes != null : !((Object)this$minutes).equals(other$minutes)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        HRModel this$person = this.getPerson();
        HRModel other$person = other.getPerson();
        if (this$person == null ? other$person != null : !this$person.equals(other$person)) {
            return false;
        }
        GroupModel this$group = this.getGroup();
        GroupModel other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        ProjectModel this$project = this.getProject();
        ProjectModel other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        EpicModel this$epic = this.getEpic();
        EpicModel other$epic = other.getEpic();
        if (this$epic == null ? other$epic != null : !this$epic.equals(other$epic)) {
            return false;
        }
        StoryModel this$story = this.getStory();
        StoryModel other$story = other.getStory();
        if (this$story == null ? other$story != null : !this$story.equals(other$story)) {
            return false;
        }
        IssueModel this$issue = this.getIssue();
        IssueModel other$issue = other.getIssue();
        if (this$issue == null ? other$issue != null : !this$issue.equals(other$issue)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkingTimeModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $minutes = this.getMinutes();
        result = result * 59 + ($minutes == null ? 43 : ((Object)$minutes).hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        HRModel $person = this.getPerson();
        result = result * 59 + ($person == null ? 43 : $person.hashCode());
        GroupModel $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        ProjectModel $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        EpicModel $epic = this.getEpic();
        result = result * 59 + ($epic == null ? 43 : $epic.hashCode());
        StoryModel $story = this.getStory();
        result = result * 59 + ($story == null ? 43 : $story.hashCode());
        IssueModel $issue = this.getIssue();
        result = result * 59 + ($issue == null ? 43 : $issue.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "WorkingTimeModel(date=" + String.valueOf(this.getDate()) + ", person=" + String.valueOf(this.getPerson()) + ", minutes=" + this.getMinutes() + ", group=" + String.valueOf(this.getGroup()) + ", project=" + String.valueOf(this.getProject()) + ", epic=" + String.valueOf(this.getEpic()) + ", story=" + String.valueOf(this.getStory()) + ", issue=" + String.valueOf(this.getIssue()) + ", description=" + this.getDescription() + ")";
    }
}

