/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.response;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import systems.dennis.flaw.model.BonusModel;
import systems.dennis.flaw.model.CurrencyModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.SalaryModel;
import systems.dennis.flaw.model.WorkLogModel;
import systems.dennis.flaw.response.ProjectSalaryContainer;
import systems.dennis.flaw.util.FormulaUtils;

public class UserInProjectSalary {
    private HRModel user;
    private SalaryModel salaryModel;
    List<ProjectSalaryContainer> containers = new ArrayList();
    private Double amountInUserCurrency = 0.0;
    private Double amountInBaseCurrencyCurrency = 0.0;
    private CurrencyModel baseCurrency;
    private Long hours = 0L;
    private Long plannedHours = 0L;
    private List<BonusModel> bonuses = new ArrayList();
    private CurrencyModel currency;

    public void addWorkLog(WorkLogModel worklogForm) {
        for (ProjectSalaryContainer container : this.containers) {
            if (!Objects.equals(container.getProject().getId(), worklogForm.getProject().getId())) continue;
            container.getLogs().add(worklogForm);
            container.setAmount(Integer.valueOf(container.getAmount() + worklogForm.getAmount()));
            return;
        }
        ProjectSalaryContainer container = new ProjectSalaryContainer();
        container.setProject(worklogForm.getProject());
        container.getLogs().add(worklogForm);
        container.setAmount(worklogForm.getAmount());
        this.containers.add(container);
    }

    public void appendBonuses() {
        for (BonusModel model : this.getBonuses()) {
            this.amountInUserCurrency = this.amountInUserCurrency + (double)model.getAmount().longValue();
        }
    }

    public long exceed() {
        return this.plannedHours - this.hours;
    }

    public double exceedSalary() {
        return FormulaUtils.run((String)this.salaryModel.getLimitFormula(), (Number)this.salaryModel.getAmount()) - this.getAmountInUserCurrency();
    }

    public HRModel getUser() {
        return this.user;
    }

    public SalaryModel getSalaryModel() {
        return this.salaryModel;
    }

    public List<ProjectSalaryContainer> getContainers() {
        return this.containers;
    }

    public Double getAmountInUserCurrency() {
        return this.amountInUserCurrency;
    }

    public Double getAmountInBaseCurrencyCurrency() {
        return this.amountInBaseCurrencyCurrency;
    }

    public CurrencyModel getBaseCurrency() {
        return this.baseCurrency;
    }

    public Long getHours() {
        return this.hours;
    }

    public Long getPlannedHours() {
        return this.plannedHours;
    }

    public List<BonusModel> getBonuses() {
        return this.bonuses;
    }

    public CurrencyModel getCurrency() {
        return this.currency;
    }

    public void setUser(HRModel user) {
        this.user = user;
    }

    public void setSalaryModel(SalaryModel salaryModel) {
        this.salaryModel = salaryModel;
    }

    public void setContainers(List<ProjectSalaryContainer> containers) {
        this.containers = containers;
    }

    public void setAmountInUserCurrency(Double amountInUserCurrency) {
        this.amountInUserCurrency = amountInUserCurrency;
    }

    public void setAmountInBaseCurrencyCurrency(Double amountInBaseCurrencyCurrency) {
        this.amountInBaseCurrencyCurrency = amountInBaseCurrencyCurrency;
    }

    public void setBaseCurrency(CurrencyModel baseCurrency) {
        this.baseCurrency = baseCurrency;
    }

    public void setHours(Long hours) {
        this.hours = hours;
    }

    public void setPlannedHours(Long plannedHours) {
        this.plannedHours = plannedHours;
    }

    public void setBonuses(List<BonusModel> bonuses) {
        this.bonuses = bonuses;
    }

    public void setCurrency(CurrencyModel currency) {
        this.currency = currency;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserInProjectSalary)) {
            return false;
        }
        UserInProjectSalary other = (UserInProjectSalary)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Double this$amountInUserCurrency = this.getAmountInUserCurrency();
        Double other$amountInUserCurrency = other.getAmountInUserCurrency();
        if (this$amountInUserCurrency == null ? other$amountInUserCurrency != null : !((Object)this$amountInUserCurrency).equals(other$amountInUserCurrency)) {
            return false;
        }
        Double this$amountInBaseCurrencyCurrency = this.getAmountInBaseCurrencyCurrency();
        Double other$amountInBaseCurrencyCurrency = other.getAmountInBaseCurrencyCurrency();
        if (this$amountInBaseCurrencyCurrency == null ? other$amountInBaseCurrencyCurrency != null : !((Object)this$amountInBaseCurrencyCurrency).equals(other$amountInBaseCurrencyCurrency)) {
            return false;
        }
        Long this$hours = this.getHours();
        Long other$hours = other.getHours();
        if (this$hours == null ? other$hours != null : !((Object)this$hours).equals(other$hours)) {
            return false;
        }
        Long this$plannedHours = this.getPlannedHours();
        Long other$plannedHours = other.getPlannedHours();
        if (this$plannedHours == null ? other$plannedHours != null : !((Object)this$plannedHours).equals(other$plannedHours)) {
            return false;
        }
        HRModel this$user = this.getUser();
        HRModel other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        SalaryModel this$salaryModel = this.getSalaryModel();
        SalaryModel other$salaryModel = other.getSalaryModel();
        if (this$salaryModel == null ? other$salaryModel != null : !this$salaryModel.equals(other$salaryModel)) {
            return false;
        }
        List this$containers = this.getContainers();
        List other$containers = other.getContainers();
        if (this$containers == null ? other$containers != null : !((Object)this$containers).equals(other$containers)) {
            return false;
        }
        CurrencyModel this$baseCurrency = this.getBaseCurrency();
        CurrencyModel other$baseCurrency = other.getBaseCurrency();
        if (this$baseCurrency == null ? other$baseCurrency != null : !this$baseCurrency.equals(other$baseCurrency)) {
            return false;
        }
        List this$bonuses = this.getBonuses();
        List other$bonuses = other.getBonuses();
        if (this$bonuses == null ? other$bonuses != null : !((Object)this$bonuses).equals(other$bonuses)) {
            return false;
        }
        CurrencyModel this$currency = this.getCurrency();
        CurrencyModel other$currency = other.getCurrency();
        return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserInProjectSalary;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $amountInUserCurrency = this.getAmountInUserCurrency();
        result = result * 59 + ($amountInUserCurrency == null ? 43 : ((Object)$amountInUserCurrency).hashCode());
        Double $amountInBaseCurrencyCurrency = this.getAmountInBaseCurrencyCurrency();
        result = result * 59 + ($amountInBaseCurrencyCurrency == null ? 43 : ((Object)$amountInBaseCurrencyCurrency).hashCode());
        Long $hours = this.getHours();
        result = result * 59 + ($hours == null ? 43 : ((Object)$hours).hashCode());
        Long $plannedHours = this.getPlannedHours();
        result = result * 59 + ($plannedHours == null ? 43 : ((Object)$plannedHours).hashCode());
        HRModel $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        SalaryModel $salaryModel = this.getSalaryModel();
        result = result * 59 + ($salaryModel == null ? 43 : $salaryModel.hashCode());
        List $containers = this.getContainers();
        result = result * 59 + ($containers == null ? 43 : ((Object)$containers).hashCode());
        CurrencyModel $baseCurrency = this.getBaseCurrency();
        result = result * 59 + ($baseCurrency == null ? 43 : $baseCurrency.hashCode());
        List $bonuses = this.getBonuses();
        result = result * 59 + ($bonuses == null ? 43 : ((Object)$bonuses).hashCode());
        CurrencyModel $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        return result;
    }

    public String toString() {
        return "UserInProjectSalary(user=" + String.valueOf(this.getUser()) + ", salaryModel=" + String.valueOf(this.getSalaryModel()) + ", containers=" + String.valueOf(this.getContainers()) + ", amountInUserCurrency=" + this.getAmountInUserCurrency() + ", amountInBaseCurrencyCurrency=" + this.getAmountInBaseCurrencyCurrency() + ", baseCurrency=" + String.valueOf(this.getBaseCurrency()) + ", hours=" + this.getHours() + ", plannedHours=" + this.getPlannedHours() + ", bonuses=" + String.valueOf(this.getBonuses()) + ", currency=" + String.valueOf(this.getCurrency()) + ")";
    }
}

