/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.util.List;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.form.BoardForm;
import systems.dennis.flaw.model.BoardModel;
import systems.dennis.flaw.model.IssueFlowModel;
import systems.dennis.flaw.repo.BoardRepo;
import systems.dennis.flaw.service.GroupableService;
import systems.dennis.flaw.service.issue.ItemCounter;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.repository.QueryCase;

@Service
@DataRetrieverDescription(model=BoardModel.class, form=BoardForm.class, repo=BoardRepo.class)
public class BoardService
extends GroupableService<BoardModel>
implements ItemCounter {
    public BoardService(WebContext holder) {
        super(holder);
    }

    public BoardModel preAdd(BoardModel object) throws ItemForAddContainsIdException {
        object.setGroup(object.getFlow().getGroup());
        return (BoardModel)super.preAdd((BaseEntity)object);
    }

    public BoardModel preEdit(BoardModel object, BoardModel original) throws UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        object.setGroup(object.getFlow().getGroup());
        return (BoardModel)super.preEdit((BaseEntity)object, (BaseEntity)original);
    }

    public List<BoardModel> getByIssueFlow(IssueFlowModel issueFlow) {
        return this.getRepository().findAll((Specification)QueryCase.equalsOf((String)"flow", (Object)issueFlow).specification());
    }
}

