/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.form.WorkingCalendarForm;
import systems.dennis.flaw.model.BonusModel;
import systems.dennis.flaw.model.CurrencyModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.SalaryModel;
import systems.dennis.flaw.model.WorkLogModel;
import systems.dennis.flaw.model.WorkingCalendarModel;
import systems.dennis.flaw.repo.BonusRepo;
import systems.dennis.flaw.response.CalculationResult;
import systems.dennis.flaw.response.UserInProjectSalary;
import systems.dennis.flaw.service.CurrencyService;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.SalaryService;
import systems.dennis.flaw.service.WorkLogService;
import systems.dennis.flaw.service.WorkingCalendarService;
import systems.dennis.flaw.util.FormulaUtils;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.AccessDeniedException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

@Service
public class CalculateSalaryService
extends ApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(CalculateSalaryService.class);
    private final SalaryService salaryService;
    private final WorkLogService workLogService;
    private final BeanCopier copier;
    private final WorkingCalendarService workingCalendarService;
    private final HRService humanResourceService;

    public CalculateSalaryService(WebContext context, SalaryService salaryService, WorkLogService workLogService, BeanCopier copier, WorkingCalendarService service, HRService humanResourceService) {
        super(context);
        this.salaryService = salaryService;
        this.workLogService = workLogService;
        this.copier = copier;
        this.workingCalendarService = service;
        this.humanResourceService = humanResourceService;
    }

    public CalculationResult calculateSalary(Integer year, Integer month) {
        WorkingCalendarModel model = this.workingCalendarService.findByYearAndMonth(year, month);
        return this.calculateSalary(model);
    }

    public CalculationResult calculateSalary(WorkingCalendarModel model) {
        CalculationResult calculationResult = new CalculationResult();
        CurrencyModel base = null;
        try {
            base = ((CurrencyService)this.getBean(CurrencyService.class)).findBase();
        }
        catch (ItemNotFoundException exception) {
            calculationResult.getNotes().add("salary.currency.not_set");
            return calculationResult;
        }
        List humanResourceModelList = this.humanResourceService.find();
        calculationResult.setCalendar((WorkingCalendarForm)this.copier.copy((Object)model, WorkingCalendarForm.class));
        if (humanResourceModelList.isEmpty()) {
            return new CalculationResult();
        }
        boolean total = false;
        for (HRModel hr : humanResourceModelList) {
            List res = this.workLogService.findByUserAndCalendar(hr, model);
            SalaryModel salary = this.salaryService.findUsersCurrentSalary(hr);
            int userTotal = 0;
            if (salary == null) {
                calculationResult.getNotes().add("salary.not.set");
                continue;
            }
            UserInProjectSalary inProjectSalary = null;
            for (WorkLogModel wl : res) {
                try {
                    inProjectSalary = calculationResult.findOrNewByProjectAndUser(hr);
                    inProjectSalary.setCurrency(salary.getCurrency());
                    inProjectSalary.addWorkLog(wl);
                    userTotal += wl.getAmount().intValue();
                }
                catch (AccessDeniedException e) {
                    log.trace("Project doesn't belong to me, so I have to ignore it");
                }
            }
            if (inProjectSalary == null) continue;
            int monthHours = (int)Math.ceil(FormulaUtils.run((String)hr.getWorkingRate().getFormula(), (Number)Math.toIntExact(model.getHoursInMonth().intValue())));
            List items = ((BonusRepo)this.getBean(BonusRepo.class)).findAllByAffectedUserAndWc(hr, model);
            for (BonusModel item : items) {
                inProjectSalary.getBonuses().add(item);
            }
            double differ = (double)userTotal / (double)monthHours;
            if (differ > 1.0) {
                calculationResult.getNotes().add("User " + hr.asValue() + " has more hours :  expected: " + monthHours + " actual: " + userTotal);
            } else if (differ < 1.0) {
                calculationResult.getNotes().add("User " + hr.asValue() + " has less hours :  expected: " + monthHours + " actual: " + userTotal);
            }
            inProjectSalary.setSalaryModel(salary);
            inProjectSalary.setHours(Long.valueOf(userTotal));
            inProjectSalary.setPlannedHours(Long.valueOf(monthHours));
            inProjectSalary.setAmountInUserCurrency(Double.valueOf(differ * (double)salary.getAmount().longValue()));
            inProjectSalary.appendBonuses();
            inProjectSalary.setBaseCurrency(base);
            inProjectSalary.setAmountInBaseCurrencyCurrency(Double.valueOf(inProjectSalary.getAmountInUserCurrency() / salary.getCurrency().getRateToBase()));
            log.trace("finished user: " + hr.asValue());
        }
        return calculationResult;
    }
}

