/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.utils.SecurityUtils;
import systems.dennis.flaw.form.ChannelSettingForm;
import systems.dennis.flaw.model.ChannelSettingModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.repo.ChannelSettingRepo;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.security.ISecurityUtils;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.service.PaginationService;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

@Service
@DataRetrieverDescription(model=ChannelSettingModel.class, form=ChannelSettingForm.class, repo=ChannelSettingRepo.class)
public class ChannelSettingService
extends PaginationService<ChannelSettingModel> {
    private static final ChannelSettingModel DEFAULT_SETTINGS = ChannelSettingService.createDefaultSettings();

    public ChannelSettingService(WebContext holder) {
        super(holder);
    }

    public ChannelSettingModel getMy() {
        return this.getRepository().findOne((Specification)((SecurityUtils)this.getBean(SecurityUtils.class)).belongsToMeSpecification()).orElseGet(() -> this.generateDefault());
    }

    public ChannelSettingModel getUsers(HRModel hr) {
        return this.getRepository().findOne((Specification)ISecurityUtils.belongsToMeQuery((Long)hr.getRemoteId()).specification()).orElseGet(() -> this.generateDefault());
    }

    public ChannelSettingModel generateDefault() {
        ChannelSettingModel model = (ChannelSettingModel)((BeanCopier)this.getBean(BeanCopier.class)).clone((Object)DEFAULT_SETTINGS);
        return (ChannelSettingModel)this.save((BaseEntity)model);
    }

    private static ChannelSettingModel createDefaultSettings() {
        ChannelSettingModel setting = new ChannelSettingModel();
        setting.setAllowEmail(Boolean.valueOf(true));
        setting.setAllowWeb(Boolean.valueOf(true));
        setting.setAllowSms(Boolean.valueOf(false));
        setting.setAllowTelegram(Boolean.valueOf(false));
        return setting;
    }
}

