/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.form.ChecklistForm;
import systems.dennis.flaw.model.ChecklistModel;
import systems.dennis.flaw.model.ProjectModel;
import systems.dennis.flaw.repo.ChecklistRepo;
import systems.dennis.flaw.service.TestResultService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=ChecklistModel.class, form=ChecklistForm.class, repo=ChecklistRepo.class)
public class ChecklistService
extends PaginationService<ChecklistModel> {
    public ChecklistService(WebContext holder) {
        super(holder);
    }

    public ChecklistModel afterAdd(ChecklistModel object) {
        Long projectId = object.getProject().getId();
        ((TestResultService)this.getContext().getBean(TestResultService.class)).generateAndSaveTestResults(projectId, object);
        return (ChecklistModel)super.afterAdd((BaseEntity)object);
    }

    public ChecklistModel findByProject(ProjectModel project) {
        return (ChecklistModel)this.getRepository().findOne((Specification)QueryCase.equalsOf((String)"project", (Object)project).specification()).orElseThrow(() -> new ItemNotFoundException((DefaultForm)project));
    }
}

