/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import java.util.List;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.service.issue.change_processors.TelegramBotProcessor;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.utils.ApplicationContext;

@Service
public class CronService
extends ApplicationContext {
    @PersistenceContext(type=PersistenceContextType.EXTENDED)
    EntityManager em;

    public CronService(WebContext context) {
        super(context);
    }

    public StringBuilder generateMessageAboutIssuesToGroup(GroupModel group) {
        StringBuilder messageAboutOpened = new StringBuilder();
        messageAboutOpened.append("Issues which was opened today: ").append("\n\n");
        StringBuilder messageAboutClosed = new StringBuilder();
        messageAboutClosed.append("Issues which was closed today: ").append("\n\n");
        List todayOpenedIssueModels = this.em.createQuery("from IssueModel i where i.group = :group and day(i.created) = day(current_date()) and month(i.created) = month(current_date()) and year(i.created) = year(current_date())").setParameter("group", (Object)group).getResultList();
        List todayClosedIssueModels = this.em.createQuery("from IssueModel i where i.group = :group and day(i.finishedOn) = day(current_date()) and month(i.finishedOn) = month(current_date()) and year(i.finishedOn) = year(current_date())").setParameter("group", (Object)group).getResultList();
        for (IssueModel issue : todayOpenedIssueModels) {
            messageAboutOpened.append(this.generateMessageToIssue(issue));
        }
        for (IssueModel issue : todayClosedIssueModels) {
            messageAboutClosed.append(this.generateMessageToIssue(issue));
        }
        StringBuilder message = new StringBuilder();
        if (todayOpenedIssueModels.size() > 0) {
            message.append((CharSequence)messageAboutOpened);
        }
        if (todayClosedIssueModels.size() > 0) {
            message.append((CharSequence)messageAboutClosed);
        }
        return message;
    }

    public String generateMessageToIssue(IssueModel issue) {
        StringBuilder message = new StringBuilder();
        message.append("<a href='").append(TelegramBotProcessor.getIssuePath((WebContext.LocalWebContext)this.getContext(), (IssueModel)issue)).append("'>Issue: ID").append(issue.getId()).append(" </a>");
        message.append(issue.getName()).append("\n\n");
        return String.valueOf(message);
    }
}

