/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.util.List;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.form.GitConfigProjectForm;
import systems.dennis.flaw.model.GitConfigProjectModel;
import systems.dennis.flaw.model.ProjectModel;
import systems.dennis.flaw.repo.GitConfigProjectRepo;
import systems.dennis.flaw.service.ProjectService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=GitConfigProjectModel.class, form=GitConfigProjectForm.class, repo=GitConfigProjectRepo.class)
@DeleteStrategy(value=2)
public class GitConfigProjectService
extends PaginationService<GitConfigProjectModel> {
    public GitConfigProjectService(WebContext holder) {
        super(holder);
    }

    public GitConfigProjectModel generateAndSave(Long projectId, String gitConfigUid) {
        ProjectModel project = (ProjectModel)((ProjectService)this.getBean(ProjectService.class)).findByIdOrThrow(projectId);
        GitConfigProjectModel model = new GitConfigProjectModel();
        model.setProject(project);
        model.setGitConfigUid(gitConfigUid);
        return (GitConfigProjectModel)this.save((BaseEntity)model);
    }

    public List<GitConfigProjectModel> getByProject(Long projectId, Long from, Integer limit, Integer page) {
        ProjectModel project = (ProjectModel)((ProjectService)this.getBean(ProjectService.class)).findByIdOrThrow(projectId);
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"project", (Object)project).specification();
        return this.find(specification.addCase(this.getNotDeletedQuery()), from, limit, page).getContent();
    }
}

