/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.CrossOrigin;
import systems.dennis.flaw.bean.populate.EpicStatusPopulate;
import systems.dennis.flaw.bean.populate.IssueFlowPopulate;
import systems.dennis.flaw.bean.populate.IssueFlowStagePopulate;
import systems.dennis.flaw.bean.populate.IssueLinkTypePopulate;
import systems.dennis.flaw.bean.populate.IssueStatusPopulate;
import systems.dennis.flaw.bean.populate.IssueTypePopulate;
import systems.dennis.flaw.bean.populate.PopulateDispatcher;
import systems.dennis.flaw.bean.populate.PriorityPopulate;
import systems.dennis.flaw.bean.populate.ProjectFlowPopulate;
import systems.dennis.flaw.bean.populate.ProjectTypePopulate;
import systems.dennis.flaw.bean.populate.SolutionTypePopulate;
import systems.dennis.flaw.bean.populate.SprintFlowPopulate;
import systems.dennis.flaw.bean.populate.SprintFlowStagePopulate;
import systems.dennis.flaw.bean.populate.SprintStatusPopulate;
import systems.dennis.flaw.bean.populate.StoryStatusPopulate;
import systems.dennis.flaw.bean.populate.WorkTypePopulate;
import systems.dennis.flaw.form.GroupForm;
import systems.dennis.flaw.form.HRForm;
import systems.dennis.flaw.form.WorkLogForm;
import systems.dennis.flaw.form.WorkLogSummaryForm;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupTypeModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.WorkLogModel;
import systems.dennis.flaw.repo.EpicStatusRepo;
import systems.dennis.flaw.repo.GroupRepo;
import systems.dennis.flaw.repo.IssueFlowRepo;
import systems.dennis.flaw.repo.IssueFlowStageRepo;
import systems.dennis.flaw.repo.IssueLinkTypeRepo;
import systems.dennis.flaw.repo.IssueStatusRepo;
import systems.dennis.flaw.repo.IssueTypeRepo;
import systems.dennis.flaw.repo.PriorityRepo;
import systems.dennis.flaw.repo.ProjectFlowRepo;
import systems.dennis.flaw.repo.ProjectTypeRepo;
import systems.dennis.flaw.repo.SolutionTypeRepo;
import systems.dennis.flaw.repo.SprintFlowRepo;
import systems.dennis.flaw.repo.SprintFlowStageRepo;
import systems.dennis.flaw.repo.SprintStatusRepo;
import systems.dennis.flaw.repo.StoryStatusRepo;
import systems.dennis.flaw.repo.WorkTypeRepo;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.TeamInGroupService;
import systems.dennis.flaw.service.UserInTeamService;
import systems.dennis.flaw.service.WorkLogService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.DeleteNotPossibleException;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.model.LanguageModel;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.PaginationRepository;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@CrossOrigin
@DeleteStrategy(value=2)
@DataRetrieverDescription(model=GroupModel.class, form=GroupForm.class, repo=GroupRepo.class)
public class GroupService
extends PaginationService<GroupModel> {
    private static final Logger log = LoggerFactory.getLogger(GroupService.class);
    public static final String GROUP_FIELD = "group";

    public GroupService(WebContext holder) {
        super(holder);
    }

    public GroupModel findByTelegramCode(long chat) {
        return (GroupModel)this.getRepository().findOne((Specification)QueryCase.equalsOf((String)"telegramId", (Object)chat).specification()).orElseThrow(() -> new ItemNotFoundException("Group is not linked to telegram channel"));
    }

    public Specification<GroupModel> getAdditionalSpecification() {
        Specification res = super.getAdditionalSpecification();
        DefaultSearchSpecification self = this.getSelfCreatedItems(this.getCurrentUser());
        if (self != null) {
            self = self.or((Specification)QueryCase.in((String)"id", ((TeamInGroupService)this.getContext().getBean(TeamInGroupService.class)).getMyGroups().stream().map(x -> x.getGroup().getId()).collect(Collectors.toList())).specification());
        }
        return self == null ? res : res.and((Specification)self);
    }

    public Specification getAdditionalGroupSpecificationQuery() {
        Specification res = super.getAdditionalSpecification();
        DefaultSearchSpecification self = this.getSelfCreatedItems(this.getCurrentUser());
        if (self != null) {
            self = self.or((Specification)QueryCase.in((String)GROUP_FIELD, ((TeamInGroupService)this.getContext().getBean(TeamInGroupService.class)).getMyGroups().stream().map(x -> x.getGroup().getId()).collect(Collectors.toList())).specification());
        }
        return self == null ? res : res.and((Specification)self);
    }

    public List<PopulateDispatcher> initializePopulateDispatchers(WebContext.LocalWebContext context, GroupModel object, LanguageModel language, GroupTypeModel groupType) {
        ArrayList<PopulateDispatcher> populateDispatchers = new ArrayList<PopulateDispatcher>();
        populateDispatchers.add((PopulateDispatcher)new IssueStatusPopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(IssueStatusRepo.class), language, groupType));
        populateDispatchers.add((PopulateDispatcher)new PriorityPopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(PriorityRepo.class), language, groupType));
        populateDispatchers.add((PopulateDispatcher)new IssueLinkTypePopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(IssueLinkTypeRepo.class), language, groupType));
        populateDispatchers.add((PopulateDispatcher)new IssueTypePopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(IssueTypeRepo.class), language, groupType));
        populateDispatchers.add((PopulateDispatcher)new SolutionTypePopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(SolutionTypeRepo.class), language, groupType));
        populateDispatchers.add((PopulateDispatcher)new IssueFlowPopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(IssueFlowRepo.class), language, groupType));
        populateDispatchers.add((PopulateDispatcher)new IssueFlowStagePopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(IssueFlowStageRepo.class), language, groupType));
        populateDispatchers.add((PopulateDispatcher)new SprintStatusPopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(SprintStatusRepo.class), language, groupType));
        populateDispatchers.add((PopulateDispatcher)new SprintFlowPopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(SprintFlowRepo.class), language, groupType));
        populateDispatchers.add((PopulateDispatcher)new SprintFlowStagePopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(SprintFlowStageRepo.class), language, groupType));
        populateDispatchers.add((PopulateDispatcher)new ProjectTypePopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(ProjectTypeRepo.class), language, groupType));
        populateDispatchers.add((PopulateDispatcher)new EpicStatusPopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(EpicStatusRepo.class), language, groupType));
        populateDispatchers.add((PopulateDispatcher)new StoryStatusPopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(StoryStatusRepo.class), language, groupType));
        populateDispatchers.add((PopulateDispatcher)new ProjectFlowPopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(ProjectFlowRepo.class), language, groupType));
        populateDispatchers.add((PopulateDispatcher)new WorkTypePopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(WorkTypeRepo.class), language, groupType));
        return populateDispatchers;
    }

    public List<PopulateDispatcher> initializeDeleteDispatchers(WebContext.LocalWebContext context, GroupModel object, LanguageModel language, GroupTypeModel groupType) {
        ArrayList<PopulateDispatcher> deleteDispatchers = new ArrayList<PopulateDispatcher>();
        deleteDispatchers.add((PopulateDispatcher)new IssueFlowPopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(IssueFlowRepo.class), language, groupType));
        deleteDispatchers.add((PopulateDispatcher)new IssueStatusPopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(IssueStatusRepo.class), language, groupType));
        deleteDispatchers.add((PopulateDispatcher)new IssueLinkTypePopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(IssueLinkTypeRepo.class), language, groupType));
        deleteDispatchers.add((PopulateDispatcher)new IssueTypePopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(IssueTypeRepo.class), language, groupType));
        deleteDispatchers.add((PopulateDispatcher)new PriorityPopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(PriorityRepo.class), language, groupType));
        deleteDispatchers.add((PopulateDispatcher)new SolutionTypePopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(SolutionTypeRepo.class), language, groupType));
        deleteDispatchers.add((PopulateDispatcher)new SprintFlowPopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(SprintFlowRepo.class), language, groupType));
        deleteDispatchers.add((PopulateDispatcher)new SprintStatusPopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(SprintStatusRepo.class), language, groupType));
        deleteDispatchers.add((PopulateDispatcher)new ProjectFlowPopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(ProjectFlowRepo.class), language, groupType));
        deleteDispatchers.add((PopulateDispatcher)new ProjectTypePopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(ProjectTypeRepo.class), language, groupType));
        deleteDispatchers.add((PopulateDispatcher)new EpicStatusPopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(EpicStatusRepo.class), language, groupType));
        deleteDispatchers.add((PopulateDispatcher)new StoryStatusPopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(StoryStatusRepo.class), language, groupType));
        deleteDispatchers.add((PopulateDispatcher)new WorkTypePopulate().init(object, this.getContext(), (PaginationRepository)this.getBean(WorkTypeRepo.class), language, groupType));
        return deleteDispatchers;
    }

    public List<GroupModel> getMyGroup() {
        return ((GroupRepo)this.getBean(GroupRepo.class)).findAll(this.getAdditionalSpecification());
    }

    public GroupModel preAdd(GroupModel object) throws ItemForAddContainsIdException {
        if (object.getIcon() == null || object.getIcon().isEmpty()) {
            int res = (int)Math.floor(Math.random() * 11.0);
            String name = "http://dennis.systems/src/img/group_" + res + ".svg";
            object.setIcon(name);
        }
        return (GroupModel)super.preAdd((BaseEntity)object);
    }

    public GroupModel preDelete(GroupModel object) {
        List myGroips = this.getMyGroup();
        if (myGroips.size() == 1) {
            throw new DeleteNotPossibleException();
        }
        return (GroupModel)super.preDelete((BaseEntity)object);
    }

    public List<WorkLogSummaryForm> getWorkLog(Long id, Long from, Integer limit, Integer page) {
        GroupModel group = (GroupModel)this.findByIdOrThrow(id);
        List teams = ((TeamInGroupService)this.getBean(TeamInGroupService.class)).getTeamByGroup(group);
        List hrs = ((UserInTeamService)this.getBean(UserInTeamService.class)).getHrByTeam(teams, from, limit, page);
        WorkLogService workLogService = (WorkLogService)this.getBean(WorkLogService.class);
        ArrayList<WorkLogSummaryForm> result = new ArrayList<WorkLogSummaryForm>();
        for (HRModel hr : hrs) {
            List worklogsModel = workLogService.findByHr(hr, group);
            ArrayList<WorkLogForm> worklogsForm = new ArrayList<WorkLogForm>();
            for (WorkLogModel model : worklogsModel) {
                worklogsForm.add((WorkLogForm)workLogService.toForm((BaseEntity)model));
            }
            WorkLogSummaryForm workLogSummaryForm = new WorkLogSummaryForm();
            workLogSummaryForm.setHr((HRForm)((HRService)this.getBean(HRService.class)).toForm((BaseEntity)hr));
            workLogSummaryForm.setWorkLogs(worklogsForm);
            result.add(workLogSummaryForm);
        }
        return result;
    }
}

