/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.domain.Specification;
import systems.dennis.flaw.exception.NoGroupException;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupableModel;
import systems.dennis.flaw.service.CountResponse;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.shared.annotations.security.ISecurityUtils;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

public class GroupableService<DB_TYPE extends BaseEntity>
extends PaginationService<DB_TYPE> {
    public static final String GROUP_FIELD = "group";

    public GroupableService(WebContext holder) {
        super(holder);
    }

    public DB_TYPE preEdit(DB_TYPE object, DB_TYPE original) throws UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        this.assignGroup(object);
        return (DB_TYPE)super.preEdit(object, original);
    }

    public DB_TYPE preAdd(DB_TYPE object) throws ItemForAddContainsIdException {
        this.assignGroup(object);
        return (DB_TYPE)super.preAdd(object);
    }

    public void assignGroup(DB_TYPE model) {
        if (model == null || !GroupableModel.class.isAssignableFrom(model.getClass())) {
            return;
        }
        GroupableModel m = (GroupableModel)model;
        if (m.getGroup() == null) {
            m.setGroup(m.findInnerGroup());
        }
        if (m.getGroup() == null) {
            throw new NoGroupException(m, "global.exceptions.no_group_is_set");
        }
    }

    public CountResponse getCountInGroup(Long groupId) {
        GroupService serviceProject = (GroupService)this.getBean(GroupService.class);
        GroupModel group = (GroupModel)serviceProject.findByIdOrThrow(groupId);
        Specification specification = this.getByGroupSpecification().and((Specification)QueryCase.equalsOf((String)GROUP_FIELD, (Object)group).specification());
        CountResponse resp = new CountResponse();
        resp.setCount(Long.valueOf(this.count(specification)));
        resp.setItem(groupId);
        return resp;
    }

    public Specification<DB_TYPE> getSearchRequestSpecification(String field, String value, Long[] additionalIds) {
        DefaultSearchSpecification spec = QueryCase.containsInSensitive((String)field, (Object)value).specification();
        Specification additionalSpecification = this.getAdditionalSpecification();
        if (additionalIds != null) {
            additionalSpecification = QueryCase.equalsOf((String)GROUP_FIELD, (Object)additionalIds[0]).specification();
        }
        if (additionalSpecification != null) {
            spec = spec.and(additionalSpecification);
        }
        return spec;
    }

    public Specification<DB_TYPE> getAdditionalSpecification() {
        return this.getByGroupSpecification();
    }

    public Specification<DB_TYPE> getByGroupSpecification() {
        if (((ISecurityUtils)this.getContext().getBean(ISecurityUtils.class)).isAdmin()) {
            return this.getNotDeletedQuery().specification();
        }
        List groups = ((GroupService)this.getBean(GroupService.class)).getMyGroup();
        if (groups.isEmpty()) {
            return this.getSelfCreatedItems(this.getCurrentUser());
        }
        DefaultSearchSpecification specification = QueryCase.in((String)GROUP_FIELD, (List)groups).specification();
        return this.getNotDeletedQuery().specification().and(specification.or((Specification)this.getSelfCreatedItems(this.getCurrentUser())));
    }

    public void checkMy(DB_TYPE object) {
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"id", (Object)object.getId()).specification();
        Optional res = this.getRepository().findFirst(specification.and(this.getByGroupSpecification()));
        if (res.isEmpty()) {
            throw new ItemNotUserException();
        }
    }
}

