/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.client.utils.SecurityUtils;
import systems.dennis.flaw.bean.populate.GroupPopulate;
import systems.dennis.flaw.exception.ConversionException;
import systems.dennis.flaw.form.HRForm;
import systems.dennis.flaw.form.InvitationForm;
import systems.dennis.flaw.form.UserProfileForm;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.repo.GroupRepo;
import systems.dennis.flaw.repo.HRRepo;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.repository.PaginationRepository;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;
import systems.dennis.shared.utils.GeneratedPojoForm;

@Service
@DataRetrieverDescription(model=HRModel.class, form=HRForm.class, repo=HRRepo.class)
@DeleteStrategy(value=2)
public class HRService
extends PaginationService<HRModel>
implements Transformable<HRModel, HRForm> {
    public HRService(WebContext holder) {
        super(holder);
    }

    public HRModel me() {
        UserData me = ((SecurityUtils)this.getBean(SecurityUtils.class)).get().getUserData();
        return this.findByDTO(me);
    }

    public HRModel byEmail(String user) {
        return (HRModel)this.getRepository().findOne((Specification)QueryCase.equalsOf((String)"email", (Object)user).specification()).orElseThrow(() -> new ItemNotFoundException(user));
    }

    private HRModel findByDTO(UserData me) {
        return (HRModel)this.getRepository().findOne((Specification)QueryCase.equalsOf((String)"email", (Object)me.getEmail()).specification()).orElseThrow(() -> new ItemNotFoundException(me.getEmail()));
    }

    public HRModel findByTelegramId(String telegram) {
        return (HRModel)this.getRepository().findOne((Specification)QueryCase.equalsOf((String)"telegramName", (Object)telegram).specification()).orElseThrow(() -> new ItemNotFoundException(telegram));
    }

    public Page<HRModel> getMyInvitedHr(List<InvitationForm> invitations) {
        ArrayList<HRModel> hr = new ArrayList<HRModel>();
        for (InvitationForm invitation : invitations) {
            hr.add(this.byEmail(invitation.getEmail()));
        }
        return new PageImpl(hr);
    }

    public HRModel preAdd(HRModel object) throws ItemForAddContainsIdException {
        if (object.getEmail() != null) {
            object.setEmail(object.getEmail().trim());
        }
        return (HRModel)super.preAdd((BaseEntity)object);
    }

    public HRModel preEdit(HRModel object, HRModel original) throws UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        if (object.getEmail() != null) {
            object.setEmail(object.getEmail().trim());
        }
        return (HRModel)super.preEdit((BaseEntity)object, (BaseEntity)original);
    }

    public HRModel afterAdd(HRModel object) {
        try {
            new GroupPopulate().init(null, this.getContext(), (PaginationRepository)this.getContext().getBean(GroupRepo.class), null, null).setHR(object).populate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (HRModel)super.afterAdd((BaseEntity)object);
    }

    public void afterEdit(HRModel object, HRModel original) {
        this.syncUserProfile(object);
        super.afterEdit((BaseEntity)object, (BaseEntity)original);
    }

    private void syncUserProfile(HRModel object) {
        Long remoteId = object.getRemoteId();
        String currentToken = ((SecurityUtils)this.getBean(SecurityUtils.class)).getToken();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + currentToken);
        GeneratedPojoForm pojoForm = this.getUserFromRemoteServer(remoteId, headers);
        UserProfileForm userProfile = this.transformPojoToUserProfile(pojoForm, object);
        this.updateUserOnRemoteServer(userProfile, headers);
    }

    private GeneratedPojoForm getUserFromRemoteServer(Long remoteId, HttpHeaders headers) {
        String fetchPath = this.getAuthPath() + "/profile/root/fetch/form?id=" + remoteId;
        ResponseEntity fetchResponse = new RestTemplate().exchange(fetchPath, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), GeneratedPojoForm.class, new Object[0]);
        return (GeneratedPojoForm)fetchResponse.getBody();
    }

    private UserProfileForm transformPojoToUserProfile(GeneratedPojoForm exchange, HRModel object) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String json = objectMapper.writeValueAsString((Object)exchange.getValue());
            UserProfileForm userProfile = (UserProfileForm)objectMapper.readValue(json, UserProfileForm.class);
            userProfile.setName(object.getName());
            userProfile.setEmail(object.getEmail());
            userProfile.setImagePath(object.getIcon());
            return userProfile;
        }
        catch (Exception e) {
            throw new ConversionException((Serializable)e, "global.exceptions.failed_to_convert_user_data");
        }
    }

    private void updateUserOnRemoteServer(UserProfileForm userProfile, HttpHeaders headers) {
        String editPath = this.getAuthPath() + "/profile/edit";
        HttpEntity requestEntity = new HttpEntity((Object)userProfile, (MultiValueMap)headers);
        new RestTemplate().exchange(editPath, HttpMethod.PUT, requestEntity, UserProfileForm.class, new Object[0]);
    }

    private String getAuthPath() {
        return (String)this.getContext().getEnv("servers.auth.request.path");
    }
}

