/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import org.springframework.stereotype.Service;
import systems.dennis.flaw.form.IssueFlowHistoryForm;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.IssueFlowHistoryModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.model.IssueStatusModel;
import systems.dennis.flaw.repo.IssueFlowHistoryRepo;
import systems.dennis.flaw.service.HRService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=IssueFlowHistoryModel.class, form=IssueFlowHistoryForm.class, repo=IssueFlowHistoryRepo.class)
public class IssueFlowHistoryService
extends PaginationService<IssueFlowHistoryModel> {
    public IssueFlowHistoryService(WebContext holder) {
        super(holder);
    }

    public IssueFlowHistoryModel saveNewIssueHistory(IssueModel issue, IssueStatusModel from, IssueStatusModel to, HRModel hr) {
        IssueFlowHistoryModel issueHistory = new IssueFlowHistoryModel();
        issueHistory.setIssue(issue);
        issueHistory.setFrom(from);
        issueHistory.setTo(to);
        issueHistory.setPerformer(hr == null ? ((HRService)this.getBean(HRService.class)).me() : hr);
        try {
            return (IssueFlowHistoryModel)this.save((BaseEntity)issueHistory);
        }
        catch (Throwable e) {
            return (IssueFlowHistoryModel)this.getRepository().save((Object)issueHistory);
        }
    }
}

