/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.form.IssueFlowForm;
import systems.dennis.flaw.model.BoardModel;
import systems.dennis.flaw.model.IssueBoardStatusModel;
import systems.dennis.flaw.model.IssueFlowModel;
import systems.dennis.flaw.model.IssueFlowStageModel;
import systems.dennis.flaw.model.IssueStatusModel;
import systems.dennis.flaw.repo.IssueFlowRepo;
import systems.dennis.flaw.service.BoardService;
import systems.dennis.flaw.service.GroupableService;
import systems.dennis.flaw.service.issue.ItemCounter;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemNotFoundException;

@Service
@DataRetrieverDescription(model=IssueFlowModel.class, form=IssueFlowForm.class, repo=IssueFlowRepo.class)
@DeleteStrategy(value=2)
public class IssueFlowService
extends GroupableService<IssueFlowModel>
implements ItemCounter {
    private final String[] colors = new String[]{"#0F6EF6", "#F8FBFF", "#66CD9B", "#E66767", "#29BDD2"};

    public IssueFlowService(WebContext holder) {
        super(holder);
    }

    public IssueFlowModel afterAdd(IssueFlowModel object) {
        BoardModel board = new BoardModel();
        this.generateAndSaveBoard(object, board);
        return (IssueFlowModel)super.afterAdd((BaseEntity)object);
    }

    public void generateAndSaveBoard(IssueFlowModel object, BoardModel model) {
        model.setFlow(object);
        model.setColor(this.getRandomColor());
        model.setName(object.getName());
        List statuses = this.getStatusesForFlow(object);
        model.setStatuses(this.toBoardStatuses(statuses));
        model.setGroup(object.getGroup());
        ((BoardService)this.getContext().getBean(BoardService.class)).save((BaseEntity)model);
    }

    public void afterEdit(IssueFlowModel object, IssueFlowModel original) {
        this.editBoard(object, original);
        super.afterEdit((BaseEntity)object, (BaseEntity)original);
    }

    private void editBoard(IssueFlowModel object, IssueFlowModel original) {
        List updatedStatuses = this.getStatusesForFlow(object);
        List originalStatuses = this.getStatusesForFlow(original);
        List addedStatuses = updatedStatuses.stream().filter(status -> !originalStatuses.contains(status)).collect(Collectors.toList());
        List removedStatuses = originalStatuses.stream().filter(status -> !updatedStatuses.contains(status)).collect(Collectors.toList());
        List boards = ((BoardService)this.getContext().getBean(BoardService.class)).getByIssueFlow(original);
        for (BoardModel board : boards) {
            List boardStatuses = this.getStatusesForFlow(board.getFlow());
            boardStatuses.removeAll(removedStatuses);
            boardStatuses.addAll(addedStatuses);
            board.setStatuses(this.toBoardStatuses(boardStatuses));
            ((BoardService)this.getContext().getBean(BoardService.class)).save((BaseEntity)board);
        }
    }

    private List<IssueBoardStatusModel> toBoardStatuses(List<IssueStatusModel> statusModels) {
        ArrayList<IssueBoardStatusModel> res = new ArrayList<IssueBoardStatusModel>();
        statusModels.forEach(x -> res.add(new IssueBoardStatusModel(x, Integer.valueOf(res.size()))));
        return res;
    }

    private List<IssueStatusModel> getStatusesForFlow(IssueFlowModel model) {
        LinkedHashSet<IssueStatusModel> models = new LinkedHashSet<IssueStatusModel>();
        if (Objects.nonNull(model.getStages())) {
            for (IssueFlowStageModel stage : model.getStages()) {
                models.add(stage.getCurrentStatus());
                models.add(stage.getNexStatus());
                models.add(stage.getPrevStatus());
            }
        }
        models.remove(null);
        return new ArrayList<IssueStatusModel>(models);
    }

    private String getRandomColor() {
        int res = (int)(Math.random() * (double)this.colors.length);
        return this.colors[res];
    }

    public List<IssueFlowStageModel> updateStages(Long id, List<IssueFlowStageModel> stages) {
        IssueFlowModel issueFlow = (IssueFlowModel)((IssueFlowService)this.getContext().getBean(IssueFlowService.class)).findById(id).orElseThrow(() -> new ItemNotFoundException(id));
        issueFlow.setStages(stages);
        this.getRepository().save((Object)issueFlow);
        return issueFlow.getStages();
    }
}

