/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.form.IssueHistoryForm;
import systems.dennis.flaw.model.CommentModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.IssueHistoryModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.repo.IssueHistoryRepo;
import systems.dennis.flaw.repo.IssueRepo;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.comment.change_processors.CommentNotificationProcessor;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=IssueHistoryModel.class, form=IssueHistoryForm.class, repo=IssueHistoryRepo.class)
public class IssueHistoryService
extends PaginationService<IssueHistoryModel> {
    public IssueHistoryService(WebContext holder) {
        super(holder);
    }

    public void saveNewIssueHistory(IssueModel to, IssueModel from) {
        this.saveFieldChange(to.getName(), from != null ? from.getName() : null, "name", to);
        this.saveFieldChange(to.getDescription(), from != null ? from.getDescription() : null, "description", to);
        this.saveFieldChange(this.toStr((BaseEntity)to.getStatus()), from != null ? this.toStr((BaseEntity)from.getStatus()) : null, "status", to);
        this.saveFieldChange(this.toStr((BaseEntity)to.getIssueType()), from != null ? this.toStr((BaseEntity)from.getIssueType()) : null, "issuetype", to);
        this.saveFieldChange(this.toStr((BaseEntity)to.getProject()), from != null ? this.toStr((BaseEntity)from.getProject()) : null, "project", to);
        this.saveFieldChange(this.toStr((BaseEntity)to.getIssueFlow()), from != null ? this.toStr((BaseEntity)from.getIssueFlow()) : null, "issueflow", to);
        this.saveFieldChange(this.toStr((BaseEntity)to.getGroup()), from != null ? this.toStr((BaseEntity)from.getGroup()) : null, "group", to);
        this.saveFieldChange(this.toStr((BaseEntity)to.getParent()), from != null ? this.toStr((BaseEntity)from.getParent()) : null, "parent", to);
        this.saveFieldChange(this.toStr((BaseEntity)to.getPerformer()), from != null ? this.toStr((BaseEntity)from.getPerformer()) : null, "performer", to);
        this.saveFieldChange(this.toStr((BaseEntity)to.getTester()), from != null ? this.toStr((BaseEntity)from.getTester()) : null, "tester", to);
        this.saveFieldChange(this.toStr((BaseEntity)to.getSolutionType()), from != null ? this.toStr((BaseEntity)from.getSolutionType()) : null, "solutiontype", to);
    }

    public Specification<IssueHistoryModel> getAdditionalSpecification() {
        List group = ((GroupService)this.getBean(GroupService.class)).getMyGroup();
        DefaultSearchSpecification specification = QueryCase.in((String)"group", (List)group).specification();
        specification.addCase(this.getNotDeletedQuery());
        List issue = ((IssueRepo)this.getContext().getBean(IssueRepo.class)).findAll((Specification)specification);
        return QueryCase.in((String)"issue", (List)issue).specification();
    }

    public void addMentionedHrToHistory(CommentModel comment) {
        Set hrs = ((CommentNotificationProcessor)this.getContext().getBean(CommentNotificationProcessor.class)).extractMentionedUsers(comment.getText(), this.getContext());
        for (HRModel hr : hrs) {
            String historyText = "The user " + hr.getEmail() + " has been mentioned in a comment";
            IssueHistoryModel issueHistory = new IssueHistoryModel();
            issueHistory.setAction("action.added");
            issueHistory.setTo(historyText);
            issueHistory.setPerformer(comment.getHr());
            issueHistory.setIssue(comment.getIssue());
            issueHistory.setDate(comment.getDate());
            issueHistory.setField("commentform.mention");
            this.save((BaseEntity)issueHistory);
        }
    }

    private void saveFieldChange(String to, String from, String field, IssueModel issue) {
        if (!Objects.equals(to, from)) {
            IssueHistoryModel issueHistory = new IssueHistoryModel();
            issueHistory.setField("issueform." + field);
            issueHistory.setAction(this.determineAction(to, from));
            issueHistory.setFrom(from);
            issueHistory.setTo(to);
            issueHistory.setPerformer(((HRService)this.getContext().getBean(HRService.class)).me());
            issueHistory.setIssue(issue);
            issueHistory.setDate(new Date());
            this.save((BaseEntity)issueHistory);
        }
    }

    public IssueHistoryModel addCommentToHistory(CommentModel origin, CommentModel target) {
        String from = origin != null ? origin.getText() : null;
        String to = target.getText();
        IssueHistoryModel issueHistory = new IssueHistoryModel();
        issueHistory.setField("commentform.comment");
        issueHistory.setAction(this.determineAction(to, from));
        issueHistory.setFrom(this.generateCommentText(from));
        issueHistory.setTo(this.generateCommentText(to));
        issueHistory.setPerformer(target.getHr());
        issueHistory.setIssue(target.getIssue());
        issueHistory.setDate(new Date());
        return (IssueHistoryModel)this.save((BaseEntity)issueHistory);
    }

    private String determineAction(String to, String from) {
        if (from == null && to != null) {
            return "action.added";
        }
        if (from != null && to == null) {
            return "action.deleted";
        }
        return "action.changed";
    }

    private String toStr(BaseEntity value) {
        return value == null ? null : value.asValue();
    }

    private String generateCommentText(String comment) {
        if (comment == null) {
            return null;
        }
        int commentLength = comment.length();
        return String.format("Added a comment of %d characters.", commentLength);
    }
}

