/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.exception.LinkLimitExceededException;
import systems.dennis.flaw.form.IssueToGitBranchForm;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.model.IssueToGitBranchModel;
import systems.dennis.flaw.repo.IssueToGitBranchRepo;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=IssueToGitBranchModel.class, form=IssueToGitBranchForm.class, repo=IssueToGitBranchRepo.class)
@DeleteStrategy
public class IssueToGitBranchService
extends PaginationService<IssueToGitBranchModel> {
    private static final long ISSUE_LIMIT = 2L;

    public IssueToGitBranchService(WebContext holder) {
        super(holder);
    }

    public IssueToGitBranchModel preAdd(IssueToGitBranchModel object) throws ItemForAddContainsIdException {
        this.validateIssueBranchLimit(object);
        return (IssueToGitBranchModel)super.preAdd((BaseEntity)object);
    }

    public IssueToGitBranchModel preEdit(IssueToGitBranchModel object, IssueToGitBranchModel original) throws UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        this.validateIssueBranchLimit(object);
        return (IssueToGitBranchModel)super.preEdit((BaseEntity)object, (BaseEntity)original);
    }

    public boolean checkIfDuplicateRelation(IssueModel issue, Long branchId) {
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"issue", (Object)issue).specification().addCase(QueryCase.equalsOf((String)"gitBranch", (Object)branchId));
        return this.getRepository().count((Specification)specification) > 0L;
    }

    private void validateIssueBranchLimit(IssueToGitBranchModel object) {
        if (!this.isBranchLinkLimit(object).booleanValue()) {
            throw new LinkLimitExceededException("global.exception.link_limit_exceeded");
        }
    }

    private Boolean isBranchLinkLimit(IssueToGitBranchModel object) {
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"gitBranch", (Object)object.getGitBranch()).specification();
        return this.count((Specification)specification) < 2L;
    }
}

