/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.form.IssueToIssueLinkForm;
import systems.dennis.flaw.model.IssueToIssueLinkModel;
import systems.dennis.flaw.repo.IssueToIssueLinkRepo;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=IssueToIssueLinkModel.class, form=IssueToIssueLinkForm.class, repo=IssueToIssueLinkRepo.class)
public class IssueToIssueLinkService
extends PaginationService<IssueToIssueLinkModel> {
    public IssueToIssueLinkService(WebContext holder) {
        super(holder);
    }

    public boolean checkIfDuplicateLinkType(IssueToIssueLinkForm form, boolean edit) {
        DefaultSearchSpecification specification = new DefaultSearchSpecification();
        specification.addCase(QueryCase.equalsOf((String)"linkType", (Object)form.getLinkType()));
        specification.addCase(QueryCase.equalsOf((String)"linked", (Object)form.getLinked()));
        specification.addCase(QueryCase.equalsOf((String)"parent", (Object)form.getParent()));
        if (edit) {
            specification.addCase(QueryCase.notEqualsOf((String)"id", (Object)form.getId()));
        }
        return this.getRepository().count((Specification)specification) > 0L;
    }
}

