/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import systems.dennis.flaw.annotation.MoveField;
import systems.dennis.flaw.exception.GroupAssignException;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.GroupableModel;
import systems.dennis.flaw.service.GroupableService;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;
import systems.dennis.shared.utils.bean_copier.BeanCopier;
import systems.dennis.shared.utils.bean_copier.DataTransformer;

public abstract class MoveObjectService<DB_TYPE extends BaseEntity>
extends GroupableService<DB_TYPE> {
    private final int COPY_BODY_ONLY = 0;
    private final int COPY_EXISTING_RELATIONS = 1;
    private final int ADD_TO = 2;

    public MoveObjectService(WebContext holder) {
        super(holder);
    }

    public DB_TYPE move(DB_TYPE model, GroupModel group, Integer condition) {
        if (Objects.equals(((GroupableModel)model).getGroup(), group)) {
            throw new GroupAssignException("global.exceptions.group_already_assign");
        }
        if (condition == null) {
            condition = 0;
        }
        Object copy = this.moveReflection(model, group, condition);
        BeanCopier.setFieldValue((Object)copy, (String)"id", (Object)model.getId());
        return (DB_TYPE)this.save((BaseEntity)copy);
    }

    private Object moveReflection(Object model, GroupModel group, Integer condition) {
        Class<?> cl = model.getClass();
        Object clone = model.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        BeanCopier.setFieldValue(clone, (String)"group", (Object)group);
        List annotatedFields = BeanCopier.findAnnotatedFields(cl, MoveField.class);
        for (Field field : annotatedFields) {
            String[] searchFields = field.getAnnotation(MoveField.class).searchFields();
            int createPolicy = field.getAnnotation(MoveField.class).createPolicy();
            Object o = BeanCopier.readValue((Object)model, (Field)field);
            if (this.shouldCopyField(o, condition, createPolicy)) {
                DefaultSearchSpecification specification = this.createSpecification(group, o, searchFields);
                Class service = field.getAnnotation(DataTransformer.class).additionalClass();
                Optional optional = ((PaginationService)this.getContext().getBean(service)).find(specification, Long.valueOf(0L), Integer.valueOf(10), Integer.valueOf(0)).stream().findFirst();
                Object fieldToSet = this.getFieldToSet(optional, o, group, condition, service, createPolicy);
                BeanCopier.setFieldValue(clone, (Field)field, (Object)fieldToSet);
                continue;
            }
            BeanCopier.setFieldValue(clone, (Field)field, (Object)o);
        }
        return clone;
    }

    private Object getFieldToSet(Optional<?> optional, Object o, GroupModel group, Integer condition, Class<?> service, int createPolicy) {
        if (optional.isEmpty() && condition == 2 && 0 == createPolicy) {
            Object generateModel = this.moveReflection(o, group, condition);
            Method saveMethod = service.getMethod("save", BaseEntity.class);
            return saveMethod.invoke(this.getContext().getBean(service), generateModel);
        }
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    private boolean shouldCopyField(Object fieldValue, Integer condition, int createPolicy) {
        return fieldValue instanceof BaseEntity && (condition == 1 || condition == 2) && 1 != createPolicy;
    }

    private DefaultSearchSpecification createSpecification(GroupModel group, Object fieldValue, String[] searchFields) {
        DefaultSearchSpecification specification = new DefaultSearchSpecification();
        specification.addCase(QueryCase.equalsOf((String)"group", (Object)group));
        if (searchFields.length > 0) {
            for (String value : searchFields) {
                if (value == null) continue;
                this.addSpecificationCase(specification, BeanCopier.readValue((Object)fieldValue, (String)value), value);
            }
        }
        return specification;
    }

    public void addSpecificationCase(DefaultSearchSpecification<? extends BaseEntity> specification, Object object, String field) {
        if (Objects.nonNull(object)) {
            specification.addCase(QueryCase.equalsOf((String)field, (Object)object));
        }
    }
}

