/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.util.Collections;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.controller.items.magic.MagicOrder;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.repository.QueryCase;

@Service
public class MyService {
    private IssueService issueService;
    private HRService service;

    public MyService(IssueService issueService, HRService service) {
        this.issueService = issueService;
        this.service = service;
    }

    public Page<IssueModel> getCreatedByMeIssues(MagicRequest request) {
        request.getCases().add(QueryCase.equalsOf((String)"creator", (Object)this.service.me()));
        return this.issueService.search(request);
    }

    public Page<IssueModel> getAssignedToMeIssues(MagicRequest request) {
        request.getCases().add(QueryCase.equalsOf((String)"performer", (Object)this.service.me()));
        return this.issueService.search(request);
    }

    public Page<IssueModel> getTestingByMeIssues(MagicRequest request) {
        request.getCases().add(QueryCase.equalsOf((String)"tester", (Object)this.service.me()));
        return this.issueService.search(request);
    }

    public HRModel findByTelegramId(String telegram) {
        return this.service.findByTelegramId(telegram);
    }

    public Page<IssueModel> getNew(MagicRequest request) {
        return this.issueService.search(request);
    }

    public Page<IssueModel> lastFinished(MagicRequest request) {
        request.setSort(Collections.singletonList(new MagicOrder("finishedOn", Boolean.valueOf(true))));
        request.getCases().add(QueryCase.ofNotNull((String)"finishedOn"));
        return this.issueService.search(request);
    }

    public Page<IssueModel> forTesting(MagicRequest request) {
        request.setSort(Collections.singletonList(new MagicOrder("forAchieveTests", Boolean.valueOf(true))));
        request.getCases().add(QueryCase.equalsOf((String)"forAchieveTests", (Object)true));
        return this.issueService.search(request);
    }
}

