/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.form.NotificationDeliveryForm;
import systems.dennis.flaw.mail.MailSender;
import systems.dennis.flaw.model.NotificationDeliveryModel;
import systems.dennis.flaw.repo.NotificationDeliveryRepo;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=NotificationDeliveryModel.class, form=NotificationDeliveryForm.class, repo=NotificationDeliveryRepo.class)
public class NotificationDeliveryService
extends PaginationService<NotificationDeliveryModel> {
    public NotificationDeliveryService(WebContext holder) {
        super(holder);
    }

    public List<NotificationDeliveryModel> getNotifications() {
        return this.getRepository().findAll((Specification)QueryCase.equalsOf((String)"delivered", (Object)false).specification());
    }

    public void sendNotification() {
        List notifications = this.getNotifications();
        HashMap<String, List> groupedRecipients = new HashMap<String, List>();
        HashMap<String, String> messageTextByTitle = new HashMap<String, String>();
        for (NotificationDeliveryModel model : notifications) {
            if (model.getChannel() != 0) continue;
            groupedRecipients.computeIfAbsent(model.getText(), recipients -> new ArrayList()).add(model.getHr().getEmail());
            messageTextByTitle.put(model.getText(), model.getTitle());
            ((NotificationDeliveryService)this.getContext().getBean(NotificationDeliveryService.class)).changeNotificationStatus(model);
        }
        this.sendGroupedEmailNotifications(groupedRecipients, messageTextByTitle);
    }

    private void sendGroupedEmailNotifications(Map<String, List<String>> groupedRecipients, Map<String, String> messageTextByTitle) {
        for (Map.Entry<String, List<String>> entry : groupedRecipients.entrySet()) {
            String text = entry.getKey();
            List<String> recipients = entry.getValue();
            String title = messageTextByTitle.get(text);
            ((MailSender)this.getContext().getBean(MailSender.class)).sendMail(recipients, text, title);
        }
    }

    public void changeNotificationStatus(NotificationDeliveryModel model) {
        model.setDeliveredDate(new Date());
        model.setDelivered(Boolean.valueOf(true));
        this.getRepository().save((Object)model);
    }
}

