/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.util.List;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.exception.ProjectFlowException;
import systems.dennis.flaw.form.ProjectForm;
import systems.dennis.flaw.model.ProjectFlowModel;
import systems.dennis.flaw.model.ProjectFlowStageModel;
import systems.dennis.flaw.model.ProjectModel;
import systems.dennis.flaw.model.ProjectStatusModel;
import systems.dennis.flaw.repo.ProjectRepo;
import systems.dennis.flaw.service.GroupableService;
import systems.dennis.flaw.service.ProjectHistoryService;
import systems.dennis.flaw.service.issue.ItemCounter;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemNotFoundException;

@Service
@DataRetrieverDescription(model=ProjectModel.class, form=ProjectForm.class, repo=ProjectRepo.class)
@DeleteStrategy(value=2)
public class ProjectService
extends GroupableService<ProjectModel>
implements ItemCounter {
    public ProjectService(WebContext holder) {
        super(holder);
    }

    public ProjectModel promote(Long projectId) {
        ProjectModel project = (ProjectModel)this.getRepository().findById((Object)projectId).orElseThrow(() -> new ItemNotFoundException(projectId));
        ProjectFlowStageModel currentStage = this.getStageFromProjectFlowByIssueId(projectId);
        ProjectStatusModel nextStatus = currentStage.getNexStatus();
        if (nextStatus == null) {
            throw new ProjectFlowException(projectId, "flow_is_finished");
        }
        project.setStatus(nextStatus);
        ((ProjectHistoryService)this.getBean(ProjectHistoryService.class)).saveNewProjectHistory(project, currentStage.getCurrentStatus(), nextStatus);
        return (ProjectModel)this.save((BaseEntity)project);
    }

    public ProjectModel demote(Long projectId) {
        ProjectModel project = (ProjectModel)this.getRepository().findById((Object)projectId).orElseThrow(() -> new ItemNotFoundException(projectId));
        ProjectFlowStageModel currentStage = this.getStageFromProjectFlowByIssueId(projectId);
        ProjectStatusModel prevStatus = currentStage.getPrevStatus();
        if (prevStatus == null) {
            throw new ProjectFlowException(projectId, "flow_is_on_the_start");
        }
        project.setStatus(prevStatus);
        ((ProjectHistoryService)this.getBean(ProjectHistoryService.class)).saveNewProjectHistory(project, currentStage.getCurrentStatus(), prevStatus);
        return (ProjectModel)this.save((BaseEntity)project);
    }

    public ProjectFlowStageModel getStageFromProjectFlowByIssueId(Long projectId) {
        ProjectModel project = (ProjectModel)this.getRepository().findById((Object)projectId).orElseThrow(() -> new ItemNotFoundException(projectId));
        ProjectFlowModel flow = project.getProjectFlow();
        if (flow == null) {
            throw new ProjectFlowException(projectId, "no_project_is_selected");
        }
        ProjectStatusModel projectStatus = project.getStatus();
        if (projectStatus == null) {
            throw new ProjectFlowException(projectId, "project_status_is_undefined");
        }
        List stages = flow.getStages();
        if (stages == null || stages.size() == 0) {
            throw new ProjectFlowException(projectId, "stages_are_not_created");
        }
        ProjectFlowStageModel currentStage = null;
        for (ProjectFlowStageModel stage : stages) {
            if (!stage.getCurrentStatus().equals((Object)projectStatus)) continue;
            currentStage = stage;
            break;
        }
        if (currentStage == null) {
            throw new ProjectFlowException(projectId, "project_is_not_consist_stage_with_status_" + String.valueOf(projectStatus));
        }
        return currentStage;
    }
}

