/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.util.Date;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.form.SalaryForm;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.SalaryModel;
import systems.dennis.flaw.repo.SalaryRepo;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=SalaryModel.class, form=SalaryForm.class, repo=SalaryRepo.class)
@DeleteStrategy(value=2)
public class SalaryService
extends PaginationService<SalaryModel> {
    public SalaryService(WebContext holder) {
        super(holder);
    }

    public SalaryModel findUsersCurrentSalary(HRModel model) {
        SalaryRepo repo = (SalaryRepo)this.getRepository();
        return repo.findFirstByHrAndSinceLessThanOrderBySinceDesc(model, new Date()).orElse(null);
    }

    public SalaryModel preAdd(SalaryModel object) throws ItemForAddContainsIdException {
        this.assignUser((BaseEntity)object);
        return (SalaryModel)super.preAdd((BaseEntity)object);
    }

    public List<SalaryModel> findByUser(HRModel model) {
        return this.getRepository().findAll((Specification)QueryCase.equalsOf((String)"hr", (Object)model).specification(), (Pageable)PageRequest.of((int)0, (int)20)).toList();
    }
}

