/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.utils.SecurityUtils;
import systems.dennis.flaw.form.TeamInGroupForm;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.TeamInGroupModel;
import systems.dennis.flaw.model.TeamModel;
import systems.dennis.flaw.model.UserInTeamModel;
import systems.dennis.flaw.repo.GroupRepo;
import systems.dennis.flaw.repo.TeamInGroupRepo;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.GroupableService;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.UserInTeamService;
import systems.dennis.flaw.service.issue.ItemCounter;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;

@Service
@DataRetrieverDescription(model=TeamInGroupModel.class, form=TeamInGroupForm.class, repo=TeamInGroupRepo.class)
public class TeamInGroupService
extends GroupableService<TeamInGroupModel>
implements ItemCounter {
    private HRService service;

    public TeamInGroupService(WebContext holder, HRService service) {
        super(holder);
        this.service = service;
    }

    public TeamInGroupModel preAdd(TeamInGroupModel object) throws ItemForAddContainsIdException {
        SecurityUtils securityUtils = (SecurityUtils)this.getBean(SecurityUtils.class);
        this.checkIsMyTeam(object.getTeam(), securityUtils);
        securityUtils.isMy((Object)object.getGroup());
        return (TeamInGroupModel)super.preAdd((BaseEntity)object);
    }

    void checkIsMyTeam(TeamModel model, SecurityUtils utils) {
        if (model == null || model.getLeader() != null && model.getLeader().equals((Object)this.service.me())) {
            return;
        }
        utils.isMy((Object)model);
    }

    public List<TeamInGroupModel> getMyGroups() {
        List userInTeams = ((UserInTeamService)this.getContext().getBean(UserInTeamService.class)).getMyTeams();
        List teams = userInTeams.stream().map(UserInTeamModel::getTeam).collect(Collectors.toList());
        DefaultSearchSpecification specification = QueryCase.in((String)"team", teams).specification();
        return this.getRepository().findAll((Specification)specification);
    }

    public boolean isHrAssignedToGroup(HRModel hr, GroupModel group) {
        List userInTeams = ((UserInTeamService)this.getContext().getBean(UserInTeamService.class)).getTeamsByHrId(hr.getId());
        List teams = userInTeams.stream().map(UserInTeamModel::getTeam).collect(Collectors.toList());
        if (Objects.equals(group.getUserDataId(), hr.getRemoteId())) {
            return true;
        }
        DefaultSearchSpecification selfSpecification = ((GroupService)this.getBean(GroupService.class)).getSelfCreatedItems(hr.getRemoteId());
        List groups = ((GroupRepo)this.getBean(GroupRepo.class)).findAll((Specification)selfSpecification);
        if (groups.contains(group)) {
            return true;
        }
        DefaultSearchSpecification specification = QueryCase.in((String)"team", teams).specification().addCase(QueryCase.equalsOf((String)"group", (Object)group));
        return this.getRepository().exists((Specification)specification);
    }

    public List<TeamModel> getTeamByGroup(GroupModel group) {
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"group", (Object)group).specification();
        return this.getRepository().findAll((Specification)specification).stream().map(TeamInGroupModel::getTeam).collect(Collectors.toList());
    }

    public List<TeamModel> getTeamByGroups(List<GroupModel> group) {
        DefaultSearchSpecification specification = QueryCase.in((String)"group", group).specification();
        return this.getRepository().findAll((Specification)specification).stream().map(TeamInGroupModel::getTeam).distinct().collect(Collectors.toList());
    }
}

