/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.form.TeamForm;
import systems.dennis.flaw.model.TeamModel;
import systems.dennis.flaw.repo.TeamRepo;
import systems.dennis.flaw.service.UserInTeamService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=TeamModel.class, form=TeamForm.class, repo=TeamRepo.class)
public class TeamService
extends PaginationService<TeamModel> {
    public TeamService(WebContext holder) {
        super(holder);
    }

    public Specification getAdditionalSpecification() {
        return super.getNotDeletedQuery().specification().and(QueryCase.equalsOf((String)"userDataId", (Object)this.getCurrentUser()).specification().or(this.getUserIntTeam()));
    }

    private Specification<Object> getUserIntTeam() {
        List items = ((UserInTeamService)this.getContext().getBean(UserInTeamService.class)).getMyTeams();
        return QueryCase.in((String)"id", items.stream().map(x -> x.getTeam().getId()).collect(Collectors.toList())).specification();
    }
}

