/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.util.List;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.model.ChecklistModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.model.TestResultModel;
import systems.dennis.flaw.repo.TestResultRepo;
import systems.dennis.flaw.service.ChecklistService;
import systems.dennis.flaw.service.issue.IssueService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=TestResultModel.class, form=TestResultModel.class, repo=TestResultRepo.class)
public class TestResultService
extends PaginationService<TestResultModel> {
    public TestResultService(WebContext holder) {
        super(holder);
    }

    public void generateAndSaveTestResults(Long projectId, ChecklistModel checklist) {
        List issues = ((IssueService)this.getContext().getBean(IssueService.class)).findAllByAchieveTest(projectId);
        for (IssueModel issue : issues) {
            this.generateAndSaveTestResult(issue, checklist);
        }
    }

    public TestResultModel generateAndSaveTestResult(IssueModel issueModel, ChecklistModel checklist) {
        TestResultModel testResult = new TestResultModel();
        testResult.setIssue(issueModel);
        testResult.setChecklist(checklist);
        return (TestResultModel)((TestResultRepo)this.getContext().getBean(TestResultRepo.class)).save((Object)testResult);
    }

    public DefaultSearchSpecification<TestResultModel> findByChecklist(Long checklistId) {
        ChecklistModel checklist = (ChecklistModel)((ChecklistService)this.getContext().getBean(ChecklistService.class)).findByIdOrThrow(checklistId);
        return QueryCase.equalsOf((String)"checklist", (Object)checklist).specification();
    }
}

