/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.form.UserInTeamForm;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.TeamModel;
import systems.dennis.flaw.model.UserInTeamModel;
import systems.dennis.flaw.repo.UserInTeamRepo;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.TeamService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=UserInTeamModel.class, form=UserInTeamForm.class, repo=UserInTeamRepo.class)
public class UserInTeamService
extends PaginationService<UserInTeamModel> {
    public UserInTeamService(WebContext holder) {
        super(holder);
    }

    public List<UserInTeamModel> getMyTeams() {
        HRModel me = ((HRService)this.getContext().getBean(HRService.class)).me();
        return this.getRepository().findAll((Specification)QueryCase.equalsOf((String)"model", (Object)me).specification());
    }

    public List<UserInTeamModel> getTeamsByHrId(Long id) {
        HRModel hr = (HRModel)((HRService)this.getContext().getBean(HRService.class)).findById(id).orElseThrow(() -> new ItemNotFoundException(id));
        return this.getRepository().findAll((Specification)QueryCase.equalsOf((String)"model", (Object)hr).specification());
    }

    public List<HRModel> getHrByTeam(List<TeamModel> teams, Long from, Integer limit, Integer page) {
        DefaultSearchSpecification specification = QueryCase.in((String)"team", teams).specification();
        return this.find(specification, from, limit, page).stream().map(UserInTeamModel::getModel).distinct().collect(Collectors.toList());
    }

    public boolean checkDuplicate(UserInTeamForm form, boolean edit) {
        HRModel hr = (HRModel)((HRService)this.getBean(HRService.class)).findByIdOrThrow(form.getModel());
        TeamModel team = (TeamModel)((TeamService)this.getBean(TeamService.class)).findByIdOrThrow(form.getTeam());
        DefaultSearchSpecification specification = new DefaultSearchSpecification();
        specification.addCase(QueryCase.equalsOf((String)"model", (Object)hr));
        specification.addCase(QueryCase.equalsOf((String)"team", (Object)team));
        if (edit) {
            specification.addCase(QueryCase.notEqualsOf((String)"id", (Object)form.getId()));
        }
        return this.getRepository().count((Specification)specification) > 0L;
    }
}

