/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.form.UserNotificationForm;
import systems.dennis.flaw.model.UserNotificationModel;
import systems.dennis.flaw.repo.UserNotificationRepo;
import systems.dennis.flaw.service.HRService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=UserNotificationModel.class, form=UserNotificationForm.class, repo=UserNotificationRepo.class)
public class UserNotificationService
extends PaginationService<UserNotificationModel> {
    private final HRService hrService;

    public UserNotificationService(WebContext holder, HRService hrService) {
        super(holder);
        this.hrService = hrService;
    }

    public List<QueryCase> getUnreadNotifications() {
        ArrayList<QueryCase> queryCases = new ArrayList<QueryCase>();
        queryCases.add(QueryCase.equalsOf((String)"recipient", (Object)this.hrService.me()));
        queryCases.add(QueryCase.equalsOf((String)"isRead", (Object)false));
        return queryCases;
    }

    public void changeNotificationReadStatus(Long notificationId, boolean isRead) {
        UserNotificationModel notificationModel = (UserNotificationModel)this.getRepository().findById((Object)notificationId).orElseThrow(() -> new ItemNotFoundException(notificationId));
        notificationModel.setIsRead(Boolean.valueOf(isRead));
        this.getRepository().save((Object)notificationModel);
    }

    public void markAsRead(UserNotificationModel model) {
        model.setIsRead(Boolean.valueOf(true));
        this.getRepository().save((Object)model);
    }
}

