/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.form.HRForm;
import systems.dennis.flaw.form.WorkLogForm;
import systems.dennis.flaw.form.WorkLogSummaryForm;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.WorkLogModel;
import systems.dennis.flaw.model.WorkingCalendarModel;
import systems.dennis.flaw.repo.WorkLogRepo;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.GroupableService;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.TeamInGroupService;
import systems.dennis.flaw.service.UserInTeamService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;

@Service
@DataRetrieverDescription(model=WorkLogModel.class, form=WorkLogForm.class, repo=WorkLogRepo.class)
public class WorkLogService
extends GroupableService<WorkLogModel>
implements Transformable<WorkLogModel, WorkLogForm> {
    public WorkLogService(WebContext holder) {
        super(holder);
    }

    public WorkLogModel preEdit(WorkLogModel object, WorkLogModel original) throws UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        if (object.getIssue() != null) {
            object.setProject(object.getIssue().getProject());
        }
        if (object.getHr() == null) {
            object.setHr(((HRService)this.getBean(HRService.class)).me());
        }
        return (WorkLogModel)super.preEdit((BaseEntity)object, (BaseEntity)original);
    }

    public WorkLogModel preAdd(WorkLogModel object) throws ItemForAddContainsIdException {
        if (object.getHr() == null) {
            object.setHr(((HRService)this.getBean(HRService.class)).me());
        }
        return (WorkLogModel)super.preAdd((BaseEntity)object);
    }

    public List<WorkLogModel> findByHr(HRModel hr, GroupModel group) {
        DefaultSearchSpecification specification = QueryCase.equalsOf((String)"userDataId", (Object)hr.getRemoteId()).specification().addCase(QueryCase.equalsOf((String)"group", (Object)group));
        return this.getRepository().findAll((Specification)specification);
    }

    public List<WorkLogModel> findByUserAndCalendar(HRModel model, WorkingCalendarModel calendarModel) {
        WorkLogRepo repo = (WorkLogRepo)this.getRepository();
        return repo.findAllByUserDataIdAndCalendarModel(model.getUserDataId(), calendarModel);
    }

    public List<WorkLogSummaryForm> getWorkLog(Integer year, Integer month, Long from, Integer limit, Integer page) {
        ArrayList<WorkLogSummaryForm> result = new ArrayList<WorkLogSummaryForm>();
        Date lastDatePrevMonth = this.getLastDateOfPrevMonth(year, month);
        Date firstDayNextMonth = this.getFirstDateOfNextMonth(year, month);
        List groups = ((GroupService)this.getContext().getBean(GroupService.class)).getMyGroup();
        List teams = ((TeamInGroupService)this.getBean(TeamInGroupService.class)).getTeamByGroups(groups);
        List hrs = ((UserInTeamService)this.getBean(UserInTeamService.class)).getHrByTeam(teams, from, limit, page);
        for (HRModel hr : hrs) {
            List models = this.findByHrAndDate(hr, lastDatePrevMonth, firstDayNextMonth);
            ArrayList<WorkLogForm> forms = new ArrayList<WorkLogForm>();
            for (WorkLogModel model : models) {
                forms.add((WorkLogForm)this.toForm((BaseEntity)model));
            }
            if (forms.isEmpty()) continue;
            WorkLogSummaryForm workLogSummaryForm = new WorkLogSummaryForm();
            workLogSummaryForm.setHr((HRForm)((HRService)this.getBean(HRService.class)).toForm((BaseEntity)hr));
            workLogSummaryForm.setWorkLogs(forms);
            result.add(workLogSummaryForm);
        }
        return result;
    }

    public List<WorkLogModel> findByHrAndDate(HRModel hr, Date lastDatePrevMonth, Date firstDayNextMonth) {
        DefaultSearchSpecification specification = QueryCase.more((String)"date", (Object)lastDatePrevMonth).specification().addCase(QueryCase.less((String)"date", (Object)firstDayNextMonth)).addCase(QueryCase.equalsOf((String)"userDataId", (Object)hr.getRemoteId()));
        Specification finalSpecification = this.getAdditionalSpecification().and((Specification)specification);
        return this.getRepository().findAll(finalSpecification);
    }

    private Date getLastDateOfPrevMonth(Integer year, Integer month) {
        Calendar cal = Calendar.getInstance();
        month = month - 2;
        cal.set(year, month, 1, 23, 59, 59);
        cal.set(year, month, cal.getActualMaximum(5));
        return cal.getTime();
    }

    private Date getFirstDateOfNextMonth(Integer year, Integer month) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, 1, 0, 0, 0);
        return cal.getTime();
    }
}

