/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.exception.WorkingCalendarException;
import systems.dennis.flaw.form.WorkingCalendarForm;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.WorkingCalendarModel;
import systems.dennis.flaw.repo.WorkingCalendarRepo;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.GroupableService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;

@Service
@DataRetrieverDescription(model=WorkingCalendarModel.class, form=WorkingCalendarForm.class, repo=WorkingCalendarRepo.class)
@DeleteStrategy(value=2)
public class WorkingCalendarService
extends GroupableService<WorkingCalendarModel> {
    public WorkingCalendarService(WebContext holder) {
        super(holder);
    }

    public WorkingCalendarModel preAdd(WorkingCalendarModel object) throws ItemForAddContainsIdException {
        WorkingCalendarRepo repo = (WorkingCalendarRepo)this.getRepository();
        if (object.getType() == null) {
            object.setType(Integer.valueOf(1));
        }
        if (object.getType() > 1) {
            throw new WorkingCalendarException("Calendar is not editable");
        }
        return (WorkingCalendarModel)super.preAdd((BaseEntity)object);
    }

    public WorkingCalendarModel preEdit(WorkingCalendarModel object, WorkingCalendarModel original) throws UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        return this.preAdd(object);
    }

    public WorkingCalendarModel findByYearAndMonth(Integer year, Integer month) {
        WorkingCalendarRepo repo = (WorkingCalendarRepo)this.getRepository();
        return (WorkingCalendarModel)repo.findFirstByYearAndMonth(year, month).orElseThrow(() -> new ItemNotFoundException("No WorkCalendar with this year/ month"));
    }

    public boolean checkDuplicateCalendar(WorkingCalendarForm form, boolean edit) {
        GroupModel group = (GroupModel)((GroupService)this.getBean(GroupService.class)).findByIdOrThrow(form.getGroup());
        DefaultSearchSpecification specification = new DefaultSearchSpecification();
        specification.addCase(QueryCase.equalsOf((String)"year", (Object)form.getYear()));
        specification.addCase(QueryCase.equalsOf((String)"month", (Object)form.getMonth()));
        specification.addCase(QueryCase.equalsOf((String)"group", (Object)group));
        if (edit) {
            specification.addCase(QueryCase.notEqualsOf((String)"id", (Object)form.getId()));
        }
        return this.getRepository().count((Specification)specification) > 0L;
    }
}

