/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service;

import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.form.WorkingRateForm;
import systems.dennis.flaw.model.WorkingRateModel;
import systems.dennis.flaw.repo.WorkingRateRepo;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=WorkingRateModel.class, form=WorkingRateForm.class, repo=WorkingRateRepo.class)
public class WorkingRateService
extends PaginationService<WorkingRateModel> {
    public WorkingRateService(WebContext holder) {
        super(holder);
    }

    public WorkingRateModel findByRateOrCreate(Double rate) {
        String workingRateFormula = "x= x * " + rate;
        return this.getRepository().findOne((Specification)QueryCase.equalsOf((String)"formula", (Object)workingRateFormula).specification()).orElseGet(() -> this.create(rate));
    }

    private WorkingRateModel create(Double rate) {
        WorkingRateModel model = new WorkingRateModel();
        model.setFormula("x= x * " + rate);
        model.setName("" + rate);
        model.setAllowShortDays(Boolean.valueOf(true));
        model.setIncludeWeekends(Boolean.valueOf(true));
        return (WorkingRateModel)this.getRepository().save((Object)model);
    }
}

