/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service.comment;

import java.util.Date;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.form.CommentForm;
import systems.dennis.flaw.model.CommentModel;
import systems.dennis.flaw.repo.CommentRepo;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.comment.AbstractCommentChangedProcess;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.service.PaginationService;

@Service
@DataRetrieverDescription(model=CommentModel.class, form=CommentForm.class, repo=CommentRepo.class)
public class CommentService
extends PaginationService<CommentModel> {
    public CommentService(WebContext holder) {
        super(holder);
    }

    public CommentModel afterAdd(CommentModel object) {
        object.setHr(((HRService)this.getContext().getBean(HRService.class)).me());
        object.setDate(new Date());
        this.getRepository().save((Object)object);
        CommentModel res = AbstractCommentChangedProcess.runAll((CommentModel)object, null, (WebContext.LocalWebContext)this.getContext());
        return (CommentModel)super.afterAdd((BaseEntity)object);
    }

    public void afterEdit(CommentModel object, CommentModel original) {
        CommentModel res = AbstractCommentChangedProcess.runAll((CommentModel)object, (CommentModel)original, (WebContext.LocalWebContext)this.getContext());
        super.afterEdit((BaseEntity)object, (BaseEntity)original);
    }

    public CommentModel preAdd(CommentModel object) throws ItemForAddContainsIdException {
        object.setDate(new Date());
        return (CommentModel)super.preAdd((BaseEntity)object);
    }
}

