/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service.comment.change_processors;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;
import systems.dennis.flaw.model.CommentModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.service.HRService;
import systems.dennis.flaw.service.comment.AbstractCommentChangedProcess;
import systems.dennis.flaw.user_notification.EmailNotificationChannel;
import systems.dennis.flaw.user_notification.WebNotificationChannel;
import systems.dennis.shared.config.WebContext;

@Component
public class CommentNotificationProcessor
extends AbstractCommentChangedProcess {
    public static final String ISSUE_VIEW_URL = "pages/issue/view/?id=";

    protected boolean run(CommentModel origin, CommentModel target, WebContext.LocalWebContext context) {
        if (origin == null) {
            this.generateCreatedNotification(target, context);
            this.generateAndSendTaggingNotification(target, context);
        }
        return true;
    }

    public boolean shouldExecute(CommentModel origin, CommentModel target, WebContext.LocalWebContext context) {
        if (origin != null && target != null) {
            return !origin.equals((Object)target);
        }
        return true;
    }

    private void generateCreatedNotification(CommentModel comment, WebContext.LocalWebContext context) {
        HashSet notifiedHRs = new HashSet();
        IssueModel issue = comment.getIssue();
        this.generateAndSaveCreatedNotification(issue, issue.getCreator(), context, notifiedHRs);
        this.generateAndSaveCreatedNotification(issue, issue.getPerformer(), context, notifiedHRs);
        this.generateAndSaveCreatedNotification(issue, issue.getTester(), context, notifiedHRs);
    }

    private void generateAndSaveCreatedNotification(IssueModel issue, HRModel hr, WebContext.LocalWebContext context, Set<HRModel> notifiedHRs) {
        if (Objects.nonNull(hr) && !notifiedHRs.contains(hr)) {
            HashMap<CallSite, String> data = new HashMap<CallSite, String>();
            String lang = hr.getDefLanguage();
            data.put((CallSite)((Object)("title_" + lang)), context.getMessageTranslation("app.config.email.comment.created", lang));
            this.addTemplateParameters(data, issue, context);
            ((EmailNotificationChannel)context.getBean(EmailNotificationChannel.class)).generate(data, "comment_created.html", hr);
            ((WebNotificationChannel)context.getBean(WebNotificationChannel.class)).generate(data, "comment_created.html", hr);
            notifiedHRs.add(hr);
        }
    }

    private void addTemplateParameters(Map<String, Object> data, IssueModel issue, WebContext.LocalWebContext context) {
        Long issueId = issue.getId();
        String url = this.getBaseUrl(context) + ISSUE_VIEW_URL + issueId;
        data.put("issueNumber", issueId);
        data.put("issueLink", url);
    }

    private void generateAndSendTaggingNotification(CommentModel comment, WebContext.LocalWebContext context) {
        IssueModel issue = comment.getIssue();
        String commentText = comment.getText();
        Set notifiedHRs = this.extractMentionedUsers(commentText, context);
        this.sendTaggingNotifications(notifiedHRs, issue, context);
    }

    public Set<HRModel> extractMentionedUsers(String commentText, WebContext.LocalWebContext context) {
        HashSet<HRModel> notifiedHRs = new HashSet<HRModel>();
        Pattern pattern = Pattern.compile("@(\\d+)");
        Matcher matcher = pattern.matcher(commentText);
        while (matcher.find()) {
            Long hrId = Long.parseLong(matcher.group(1));
            Optional hrOptional = ((HRService)context.getBean(HRService.class)).findById(hrId);
            hrOptional.ifPresent(notifiedHRs::add);
        }
        return notifiedHRs;
    }

    private void sendTaggingNotifications(Set<HRModel> notifiedHRs, IssueModel issue, WebContext.LocalWebContext context) {
        for (HRModel hr : notifiedHRs) {
            String lang = hr.getDefLanguage();
            HashMap<CallSite, String> data = new HashMap<CallSite, String>();
            this.addTemplateParameters(data, issue, context);
            data.put((CallSite)((Object)("title_" + lang)), context.getMessageTranslation("app.config.email.comment.tagging", lang));
            ((EmailNotificationChannel)context.getBean(EmailNotificationChannel.class)).generate(data, "comment_tagging.html", hr);
            ((WebNotificationChannel)context.getBean(WebNotificationChannel.class)).generate(data, "comment_tagging.html", hr);
        }
    }

    private String getBaseUrl(WebContext.LocalWebContext context) {
        return (String)context.getEnv("app.settings.site.self.ui");
    }
}

