/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service.comment.change_processors;

import java.util.Set;
import org.springframework.stereotype.Component;
import systems.dennis.flaw.bean.TelegramBotBean;
import systems.dennis.flaw.model.CommentModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.service.comment.AbstractCommentChangedProcess;
import systems.dennis.flaw.service.comment.change_processors.CommentNotificationProcessor;
import systems.dennis.flaw.service.issue.change_processors.TelegramBotProcessor;
import systems.dennis.shared.config.WebContext;

@Component
public class CommentTelegramBotProcessor
extends AbstractCommentChangedProcess {
    protected boolean run(CommentModel origin, CommentModel target, WebContext.LocalWebContext context) {
        if (origin == null) {
            this.generateCreatedNotification(target, context);
        }
        return true;
    }

    public boolean shouldExecute(CommentModel origin, CommentModel target, WebContext.LocalWebContext context) {
        return ((TelegramBotBean)context.getBean(TelegramBotBean.class)).isActive() && target.getIssue().getGroup().getTelegramId() != null && target.getIssue().getGroup().getTelegramId() != 0L;
    }

    private void generateCreatedNotification(CommentModel comment, WebContext.LocalWebContext context) {
        IssueModel issue = comment.getIssue();
        Set hrs = ((CommentNotificationProcessor)context.getBean(CommentNotificationProcessor.class)).extractMentionedUsers(comment.getText(), context);
        String message = this.generateTelegramMessage(issue, comment, hrs, context);
        ((TelegramBotBean)context.getBean(TelegramBotBean.class)).sendMessage(comment.getIssue().getGroup(), message);
    }

    private String generateTelegramMessage(IssueModel issue, CommentModel comment, Set<HRModel> hrs, WebContext.LocalWebContext context) {
        StringBuilder message = new StringBuilder().append("New comment added to issue <a href='" + this.getBaseUrl(context) + "pages/issue/view/?id=" + issue.getId() + "'>ID" + issue.getId() + "</a>\n").append("Title: ").append(issue.getName()).append("\n").append("Author: ").append(comment.getHr().getName());
        if (!hrs.isEmpty()) {
            message.append("\n").append("Attention to:");
            for (HRModel hr : hrs) {
                message.append(" ").append(TelegramBotProcessor.createTelegramUser((HRModel)hr));
            }
        }
        return message.toString();
    }

    private String getBaseUrl(WebContext.LocalWebContext context) {
        return (String)context.getEnv("app.settings.site.self.ui");
    }
}

