/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service.issue;

import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.service.issue.change_processors.AddToTestResultProcessor;
import systems.dennis.flaw.service.issue.change_processors.FinalDateProcessor;
import systems.dennis.flaw.service.issue.change_processors.NotificationProcessor;
import systems.dennis.flaw.service.issue.change_processors.SaveIssueFlowHistoryProcessor;
import systems.dennis.flaw.service.issue.change_processors.SaveIssueHistoryProcessor;
import systems.dennis.flaw.service.issue.change_processors.SetDefaultFlowProcessor;
import systems.dennis.flaw.service.issue.change_processors.SetDefaultStatusProcessor;
import systems.dennis.flaw.service.issue.change_processors.TelegramBotProcessor;
import systems.dennis.shared.config.WebContext;

public abstract class AbstractIssueChangedProcess {
    @Deprecated
    protected abstract boolean run(IssueModel var1, IssueModel var2, WebContext.LocalWebContext var3);

    public abstract boolean shouldExecute(IssueModel var1, IssueModel var2, WebContext.LocalWebContext var3);

    public boolean execute(IssueModel origin, IssueModel target, WebContext.LocalWebContext context) {
        try {
            if (this.shouldExecute(origin, target, context)) {
                return this.run(origin, target, context);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static IssueModel runAll(IssueModel target, IssueModel origin, WebContext.LocalWebContext context) {
        new SetDefaultStatusProcessor().execute(origin, target, context);
        new SaveIssueFlowHistoryProcessor().execute(origin, target, context);
        new FinalDateProcessor().execute(origin, target, context);
        new TelegramBotProcessor().execute(origin, target, context);
        new NotificationProcessor().execute(origin, target, context);
        new AddToTestResultProcessor().execute(origin, target, context);
        new SetDefaultFlowProcessor().execute(origin, target, context);
        new SaveIssueHistoryProcessor().execute(origin, target, context);
        return target;
    }
}

