/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service.issue;

import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import systems.dennis.flaw.controller.issue.IssueController;
import systems.dennis.flaw.controller.issue.SimilarIssueRequest;
import systems.dennis.flaw.exception.IssueFlowException;
import systems.dennis.flaw.form.IssueForm;
import systems.dennis.flaw.form.IssueFormHolder;
import systems.dennis.flaw.model.BoardModel;
import systems.dennis.flaw.model.GroupModel;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.IssueFlowModel;
import systems.dennis.flaw.model.IssueFlowStageModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.model.IssueStatusModel;
import systems.dennis.flaw.model.ProjectModel;
import systems.dennis.flaw.model.SprintModel;
import systems.dennis.flaw.repo.IssueRepo;
import systems.dennis.flaw.service.BoardService;
import systems.dennis.flaw.service.GroupService;
import systems.dennis.flaw.service.IssueFlowService;
import systems.dennis.flaw.service.IssueStatusService;
import systems.dennis.flaw.service.MoveObjectService;
import systems.dennis.flaw.service.ProjectService;
import systems.dennis.flaw.service.UserNotificationService;
import systems.dennis.flaw.service.issue.AbstractIssueChangedProcess;
import systems.dennis.flaw.service.issue.ItemCounter;
import systems.dennis.flaw.service.sprint.SprintService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.entity.BaseEntity;
import systems.dennis.shared.entity.DefaultForm;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.repository.DefaultSearchSpecification;
import systems.dennis.shared.repository.QueryCase;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

@Service
@DeleteStrategy(value=2)
@DataRetrieverDescription(model=IssueModel.class, form=IssueForm.class, repo=IssueRepo.class)
public class IssueService
extends MoveObjectService<IssueModel>
implements Transformable<IssueModel, IssueForm>,
ItemCounter {
    private static final Logger log = LoggerFactory.getLogger(IssueService.class);
    public final UserNotificationService userNotificationService;

    public IssueService(WebContext holder, UserNotificationService userNotificationService) {
        super(holder);
        this.userNotificationService = userNotificationService;
    }

    public IssueFormHolder promote(Long issueId) {
        IssueModel issue = (IssueModel)this.findByIdClone(issueId).orElseThrow(() -> new ItemNotFoundException(issueId));
        IssueFlowStageModel currentStage = this.getStageFromIssueFlowByIssueId(issueId);
        IssueStatusModel nextStatus = currentStage.getNexStatus();
        if (nextStatus == null) {
            throw new IssueFlowException(issueId, "flow_is_finished");
        }
        issue.setStatus(nextStatus);
        IssueModel issueAfterPromote = (IssueModel)this.save((BaseEntity)issue);
        return this.createIssueFormHolder(issueAfterPromote);
    }

    public IssueFormHolder demote(Long issueId) {
        IssueModel issue = (IssueModel)this.findByIdClone(issueId).orElseThrow(() -> new ItemNotFoundException(issueId));
        IssueFlowStageModel currentStage = this.getStageFromIssueFlowByIssueId(issueId);
        IssueStatusModel prevStatus = currentStage.getPrevStatus();
        if (prevStatus == null) {
            throw new IssueFlowException(issueId, "flow_is_on_the_start");
        }
        issue.setStatus(prevStatus);
        IssueModel issueAfterDemote = (IssueModel)this.save((BaseEntity)issue);
        return this.createIssueFormHolder(issueAfterDemote);
    }

    public IssueFormHolder checkAdjacentStatus(Long issueId) {
        try {
            IssueModel issue = (IssueModel)this.findByIdClone(issueId).orElseThrow(() -> new ItemNotFoundException(issueId));
            return this.createIssueFormHolder(issue);
        }
        catch (Exception e) {
            IssueFormHolder formHolder = new IssueFormHolder();
            formHolder.setHasForward(Boolean.valueOf(false));
            formHolder.setHasBack(Boolean.valueOf(false));
            return formHolder;
        }
    }

    public void setStatusEx(IssueModel model, IssueStatusModel statusObj, HRModel hr) {
        model.setStatus(statusObj);
        this.save((BaseEntity)model);
    }

    public IssueFlowStageModel getStageFromIssueFlowByIssueId(Long issueId) {
        IssueModel issue = (IssueModel)this.getRepository().findById((Object)issueId).orElseThrow(() -> new ItemNotFoundException(issueId));
        IssueFlowModel flow = issue.getIssueFlow();
        if (flow == null) {
            throw new IssueFlowException(issueId, "no_flow_is_selected");
        }
        IssueStatusModel issueStatus = issue.getStatus();
        if (issueStatus == null) {
            throw new IssueFlowException(issueId, "issue_status_is_undefined");
        }
        List stages = flow.getStages();
        if (stages == null || stages.size() == 0) {
            throw new IssueFlowException(issueId, "stages_are_not_created");
        }
        IssueFlowStageModel currentStage = null;
        for (IssueFlowStageModel stage : stages) {
            if (!stage.getCurrentStatus().equals((Object)issueStatus)) continue;
            currentStage = stage;
            break;
        }
        if (currentStage == null) {
            throw new IssueFlowException(issueId, "flow_is_not_consist_stage_with_status_" + String.valueOf(issueStatus));
        }
        return currentStage;
    }

    public IssueModel preAdd(IssueModel object) throws ItemForAddContainsIdException {
        return (IssueModel)super.preAdd((BaseEntity)object);
    }

    public IssueModel preEdit(IssueModel object, IssueModel original) throws UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        return (IssueModel)super.preEdit((BaseEntity)object, (BaseEntity)original);
    }

    public IssueModel afterAdd(IssueModel object) {
        IssueModel res = AbstractIssueChangedProcess.runAll((IssueModel)object, null, (WebContext.LocalWebContext)this.getContext());
        this.getRepository().save((Object)res);
        return (IssueModel)super.afterAdd((BaseEntity)object);
    }

    public void afterEdit(IssueModel object, IssueModel original) {
        IssueModel res = AbstractIssueChangedProcess.runAll((IssueModel)object, (IssueModel)original, (WebContext.LocalWebContext)this.getContext());
        this.getRepository().save((Object)res);
    }

    public List<IssueModel> getLastFiveIssuesByPerformer(HRModel performer, EntityManager entityManager) {
        List issues = entityManager.createQuery("from IssueModel u where u.performer = :performer AND u.finishedOn is null order by u.priority.prioNumber desc, u.id desc ").setParameter("performer", (Object)performer).setMaxResults(5).getResultList();
        return issues;
    }

    public IssueRepo getRepository() {
        return (IssueRepo)super.getRepository();
    }

    public List<Map<String, Object>> findBySprintId(Long id) {
        SprintModel sprint = (SprintModel)((SprintService)this.getContext().getBean(SprintService.class)).findByIdOrThrow(id);
        Page res = this.getRepository().findAll((Specification)QueryCase.equalsOf((String)"sprint", (Object)sprint).specification(), Pageable.unpaged());
        ArrayList<Map<String, Object>> resList = new ArrayList<Map<String, Object>>();
        for (IssueModel element : res.getContent()) {
            resList.add(BeanCopier.values((DefaultForm)((IssueController)this.getBean(IssueController.class)).toForm((BaseEntity)element), (BaseEntity)element, (WebContext.LocalWebContext)this.getContext()));
        }
        return resList;
    }

    public List<IssueModel> findAllByAchieveTest(Long projectId) {
        return this.getRepository().findAll((Specification)this.getAchieveTestSpecification(projectId));
    }

    public DefaultSearchSpecification<IssueModel> getAchieveTestSpecification(Long projectId) {
        DefaultSearchSpecification specification = new DefaultSearchSpecification();
        specification.addCase(QueryCase.equalsOf((String)"forAchieveTests", (Object)true));
        if (Objects.nonNull(projectId)) {
            ProjectModel project = (ProjectModel)((ProjectService)this.getContext().getBean(ProjectService.class)).findByIdOrThrow(projectId);
            GroupModel group = project.getGroup();
            specification.addCase(QueryCase.equalsOf((String)"project", (Object)project));
            specification.addCase(QueryCase.equalsOf((String)"group", (Object)group));
        }
        return specification;
    }

    public Page<IssueModel> findByBoard(Long id, Long statusId, int page) {
        BoardModel board = (BoardModel)((BoardService)this.getBean(BoardService.class)).findByIdOrThrow(id);
        IssueStatusModel status = (IssueStatusModel)((IssueStatusService)this.getBean(IssueStatusService.class)).findByIdOrThrow(statusId);
        DefaultSearchSpecification findBoardIssueSpecification = QueryCase.equalsOf((String)"issueFlow", (Object)board.getFlow()).specification();
        findBoardIssueSpecification = findBoardIssueSpecification.and((Specification)QueryCase.equalsOf((String)"status", (Object)status).specification());
        return this.find((Specification)findBoardIssueSpecification, Long.valueOf(0L), Integer.valueOf(25), Integer.valueOf(page));
    }

    public IssueModel closeIssue(Long id) {
        IssueStatusModel lastStatus;
        IssueModel issue = (IssueModel)this.findByIdOrThrow(id);
        if (Objects.nonNull(issue.getIssueFlow()) && !Objects.equals(lastStatus = this.getLastStatus(issue), issue.getStatus())) {
            issue.setStatus(this.getLastStatus(issue));
            return (IssueModel)this.save((BaseEntity)issue);
        }
        if (Objects.isNull(issue.getFinishedOn())) {
            issue.setFinishedOn(new Date());
            issue = (IssueModel)this.getRepository().save((Object)issue);
        }
        return issue;
    }

    private IssueStatusModel getLastStatus(IssueModel issue) {
        IssueFlowModel issueFlow = issue.getIssueFlow();
        List stages = issueFlow.getStages();
        for (IssueFlowStageModel stage : stages) {
            if (stage.getNexStatus() != null) continue;
            return stage.getCurrentStatus();
        }
        return issue.getStatus();
    }

    private IssueFormHolder createIssueFormHolder(IssueModel issue) {
        boolean hasForwardStatus = false;
        boolean hasBackStatus = false;
        try {
            IssueFlowStageModel issueFlowStage = this.getStageFromIssueFlowByIssueId(issue.getId());
            hasForwardStatus = issueFlowStage.getNexStatus() != null;
            hasBackStatus = issueFlowStage.getPrevStatus() != null;
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        IssueFormHolder issueFormHolder = new IssueFormHolder();
        issueFormHolder.setIssueForm((IssueForm)this.toForm((BaseEntity)issue));
        issueFormHolder.setHasForward(Boolean.valueOf(hasForwardStatus));
        issueFormHolder.setHasBack(Boolean.valueOf(hasBackStatus));
        return issueFormHolder;
    }

    public boolean checkStatusRestriction(IssueForm issue) {
        if (!this.isStatusRestriction()) {
            return false;
        }
        if (issue.getIssueFlow() == null || issue.getStatus() == null || issue.getIssueFlow() < 1L) {
            return false;
        }
        IssueFlowModel issueFlow = (IssueFlowModel)((IssueFlowService)this.getBean(IssueFlowService.class)).findByIdOrThrow(issue.getIssueFlow());
        IssueStatusModel status = (IssueStatusModel)((IssueStatusService)this.getBean(IssueStatusService.class)).findByIdOrThrow(issue.getStatus());
        for (IssueFlowStageModel stage : issueFlow.getStages()) {
            if (!status.equals((Object)stage.getPrevStatus()) && !status.equals((Object)stage.getCurrentStatus()) && !status.equals((Object)stage.getNexStatus())) continue;
            return false;
        }
        return true;
    }

    private boolean isStatusRestriction() {
        return (Boolean)this.getContext().getEnv("app.status.flow.restriction.enabled", (Object)true);
    }

    public Page<IssueModel> findSimilar(SimilarIssueRequest request) {
        if (request.getSearchText() == null) {
            return Page.empty();
        }
        if (request.getLimit() == null || request.getLimit() < 1) {
            request.setLimit(Integer.valueOf(0));
        }
        if (request.getLimit() != null && request.getLimit() > 100) {
            request.setLimit(Integer.valueOf(10));
        }
        String[] textElements = request.getSearchText().split(" ");
        Specification findRelated = this.getAdditionalSpecification();
        if (request.getGroup() != null && request.getGroup() > 0L) {
            GroupModel group = (GroupModel)((GroupService)this.getBean(GroupService.class)).findByIdOrThrow(request.getGroup());
            findRelated = findRelated.and((Specification)QueryCase.equalsOf((String)"group", (Object)group).specification());
        }
        DefaultSearchSpecification or = QueryCase.containsInSensitive((String)"name", (Object)request.getSearchText()).specification();
        for (String el : textElements) {
            if (el.length() <= 3) continue;
            or = or.or((Specification)QueryCase.containsInSensitive((String)"name", (Object)el).specification());
        }
        return this.find(findRelated.and((Specification)or), Long.valueOf(0L), request.getLimit(), Integer.valueOf(0));
    }
}

