/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service.issue.change_processors;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import systems.dennis.flaw.model.IssueFlowModel;
import systems.dennis.flaw.model.IssueFlowStageModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.model.IssueStatusModel;
import systems.dennis.flaw.model.SprintFlowModel;
import systems.dennis.flaw.model.SprintFlowStageModel;
import systems.dennis.flaw.model.SprintModel;
import systems.dennis.flaw.model.SprintStatusModel;
import systems.dennis.flaw.model.view.SprintProgressView;
import systems.dennis.flaw.repo.SprintProgressViewRepo;
import systems.dennis.flaw.service.issue.AbstractIssueChangedProcess;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemNotFoundException;

public class FinalDateProcessor
extends AbstractIssueChangedProcess {
    protected boolean run(IssueModel origin, IssueModel target, WebContext.LocalWebContext context) {
        if (target.isForceUpdate() || origin != null && origin.isForceUpdate()) {
            return true;
        }
        if (origin == null && (this.isIssueStatusLast(target) || this.isStatusClosed(target.getStatus()))) {
            target.setFinishedOn(new Date());
        }
        if (!Objects.equals(target.getStatus(), origin.getStatus())) {
            if (this.isIssueStatusLast(target) || this.isStatusClosed(target.getStatus())) {
                if (origin.getFinishedOn() == null) {
                    target.setFinishedOn(new Date());
                    SprintModel sprint = target.getSprint();
                    SprintProgressView sprintProgressView = (SprintProgressView)((SprintProgressViewRepo)context.getBean(SprintProgressViewRepo.class)).findBySprintId(sprint.getId()).orElseThrow(() -> new ItemNotFoundException(sprint.getId()));
                    if (sprintProgressView.getTotal() == sprintProgressView.getFinished() + 1L && sprintProgressView.getTotal() != 0L) {
                        sprint.setStatus(sprint.getAll_tasks_status());
                        if (this.isSprintStatusLast(sprint)) {
                            sprint.setFinishedOn(new Date());
                        }
                    }
                }
            } else if (target.getFinishedOn() != null) {
                target.setFinishedOn(null);
                SprintModel sprint = target.getSprint();
                SprintProgressView sprintProgressView = (SprintProgressView)((SprintProgressViewRepo)context.getBean(SprintProgressViewRepo.class)).findBySprintId(sprint.getId()).orElseThrow(() -> new ItemNotFoundException(sprint.getId()));
                if (sprintProgressView.getTotal() != sprintProgressView.getFinished() - 1L && sprint.getFinishedOn() != null) {
                    sprint.setFinishedOn(null);
                    sprint.setStatus(((SprintFlowStageModel)sprint.getSprintFlow().getStages().get(0)).getCurrentStatus());
                }
            }
        }
        return true;
    }

    public boolean shouldExecute(IssueModel origin, IssueModel target, WebContext.LocalWebContext context) {
        return target != null && target.getStatus() != null;
    }

    public boolean isIssueStatusLast(IssueModel issue) {
        IssueFlowModel flow = issue.getIssueFlow();
        if (flow == null) {
            return false;
        }
        List stages = flow.getStages();
        IssueStatusModel status = issue.getStatus();
        for (IssueFlowStageModel stage : stages) {
            if (!stage.getCurrentStatus().equals((Object)status)) continue;
            if (stage.getNexStatus() != null) break;
            return true;
        }
        return false;
    }

    public boolean isSprintStatusLast(SprintModel sprintModel) {
        SprintFlowModel flow = sprintModel.getSprintFlow();
        if (flow == null) {
            return false;
        }
        List stages = flow.getStages();
        SprintStatusModel status = sprintModel.getStatus();
        for (SprintFlowStageModel stage : stages) {
            if (!stage.getCurrentStatus().equals((Object)status)) continue;
            if (stage.getNexStatus() == null) break;
            return false;
        }
        return true;
    }

    private boolean isStatusClosed(IssueStatusModel issueStatus) {
        Boolean isClosed = issueStatus.getIsClosed();
        return isClosed != null && isClosed != false;
    }
}

