/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.flaw.service.issue.change_processors;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.stereotype.Component;
import systems.dennis.flaw.exception.NotificationDeliveryException;
import systems.dennis.flaw.model.HRModel;
import systems.dennis.flaw.model.IssueModel;
import systems.dennis.flaw.model.ViewerModel;
import systems.dennis.flaw.service.ViewerService;
import systems.dennis.flaw.service.issue.AbstractIssueChangedProcess;
import systems.dennis.flaw.user_notification.EmailNotificationChannel;
import systems.dennis.flaw.user_notification.WebNotificationChannel;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.BaseEntity;

@Component
public class NotificationProcessor
extends AbstractIssueChangedProcess {
    public static final String ISSUE_VIEW_URL = "pages/issue/view/?id=";

    public boolean run(IssueModel origin, IssueModel target, WebContext.LocalWebContext context) {
        if (origin == null) {
            this.generateCreatedNotification(target, context);
        } else {
            this.generateUpdatedNotification(target, origin, context);
        }
        return true;
    }

    public boolean shouldExecute(IssueModel origin, IssueModel target, WebContext.LocalWebContext context) {
        if (origin != null && target != null) {
            return !origin.equals((Object)target);
        }
        return true;
    }

    private void generateCreatedNotification(IssueModel object, WebContext.LocalWebContext context) {
        HashSet notifiedHRs = new HashSet();
        this.generateAndSaveCreatedNotification(object, object.getCreator(), context, notifiedHRs);
        this.generateAndSaveCreatedNotification(object, object.getPerformer(), context, notifiedHRs);
        this.generateAndSaveCreatedNotification(object, object.getTester(), context, notifiedHRs);
    }

    private void generateAndSaveCreatedNotification(IssueModel issue, HRModel hr, WebContext.LocalWebContext context, Set<HRModel> notifiedHRs) {
        if (Objects.nonNull(hr) && !notifiedHRs.contains(hr)) {
            HashMap<CallSite, String> data = new HashMap<CallSite, String>();
            String lang = hr.getDefLanguage();
            data.put((CallSite)((Object)("title_" + lang)), context.getMessageTranslation("app.config.email.issue.created", lang));
            data.put((CallSite)((Object)("content_" + lang)), this.generateCreatedNotificationContent(issue, context, lang));
            ((EmailNotificationChannel)context.getBean(EmailNotificationChannel.class)).generate(data, "issue_created.html", hr);
            ((WebNotificationChannel)context.getBean(WebNotificationChannel.class)).generate(data, "issue_created.html", hr);
            notifiedHRs.add(hr);
        }
    }

    private void generateUpdatedNotification(IssueModel object, IssueModel original, WebContext.LocalWebContext context) {
        HashSet notifiedHRs = new HashSet();
        this.generateAndSaveUpdatedNotification(object, original, object.getCreator(), context, notifiedHRs);
        this.generateAndSaveUpdatedNotification(object, original, object.getPerformer(), context, notifiedHRs);
        this.generateAndSaveUpdatedNotification(object, original, object.getTester(), context, notifiedHRs);
        this.addViewers(object, original, context, notifiedHRs);
    }

    private void generateAndSaveUpdatedNotification(IssueModel object, IssueModel original, HRModel hr, WebContext.LocalWebContext context, Set<HRModel> notifiedHRs) {
        if (Objects.nonNull(hr) && !notifiedHRs.contains(hr)) {
            HashMap<CallSite, String> data = new HashMap<CallSite, String>();
            String lang = hr.getDefLanguage();
            data.put((CallSite)((Object)("title_" + lang)), context.getMessageTranslation("app.config.email.issue.edited", lang));
            data.put((CallSite)((Object)("content_" + lang)), this.generateUpdatedNotificationContent(object, original, context, lang));
            ((EmailNotificationChannel)context.getBean(EmailNotificationChannel.class)).generate(data, "issue_updated.html", hr);
            ((WebNotificationChannel)context.getBean(WebNotificationChannel.class)).generate(data, "issue_updated.html", hr);
            notifiedHRs.add(hr);
        }
    }

    private String generateCreatedNotificationContent(IssueModel model, WebContext.LocalWebContext context, String lang) {
        StringBuilder content = new StringBuilder();
        String issueLink = "<a href=\"" + String.valueOf(context.getEnv("app.settings.site.self.ui")) + ISSUE_VIEW_URL + model.getId() + "\">ID" + model.getId() + "</a>";
        return content.append("<p>").append(String.format(context.getMessageTranslation("app.message.created.issue", lang), issueLink)).append("</p>").append(this.appendField("priority", lang, (BaseEntity)model.getPriority(), context)).append(this.appendField("performer", lang, (BaseEntity)model.getPerformer(), context)).append(this.appendField("creator", lang, (BaseEntity)model.getCreator(), context)).append(this.appendField("qa", lang, (BaseEntity)model.getTester(), context)).append(this.appendField("status", lang, (BaseEntity)model.getStatus(), context)).append(this.appendField("issueflow", lang, (BaseEntity)model.getIssueFlow(), context)).append(this.appendParentIssue(model, context, lang)).append(this.appendField("issuetype", lang, (BaseEntity)model.getIssueType(), context)).append(this.appendField("project", lang, (BaseEntity)model.getProject(), context)).append(this.appendField("solutiontype", lang, (BaseEntity)model.getSolutionType(), context)).toString();
    }

    private String appendField(String key, String lang, BaseEntity value, WebContext.LocalWebContext context) {
        String messageKey = "app.message.created." + key;
        return "<p>" + context.getMessageTranslation(messageKey, lang) + this.toStr(value) + "</p>";
    }

    private String generateUpdatedNotificationContent(IssueModel object, IssueModel original, WebContext.LocalWebContext context, String lang) {
        StringBuilder content = new StringBuilder();
        String issueLink = "<a href=\"" + String.valueOf(context.getEnv("app.settings.site.self.ui")) + ISSUE_VIEW_URL + object.getId() + "\">ID" + object.getId() + "</a>";
        content.append("<p>").append(String.format(context.getMessageTranslation("app.message.edited.issue", lang), issueLink)).append("</p>").append(this.appendChange("priority", (BaseEntity)original.getPriority(), (BaseEntity)object.getPriority(), context, lang)).append(this.appendChange("performer", (BaseEntity)original.getPerformer(), (BaseEntity)object.getPerformer(), context, lang)).append(this.appendChange("status", (BaseEntity)original.getStatus(), (BaseEntity)object.getStatus(), context, lang)).append(this.appendChange("issueflow", (BaseEntity)original.getIssueFlow(), (BaseEntity)object.getIssueFlow(), context, lang)).append(this.appendChange("qa", (BaseEntity)original.getTester(), (BaseEntity)object.getTester(), context, lang)).append(this.appendParentIssue(object, context, lang)).append(this.appendChange("issuetype", (BaseEntity)original.getIssueType(), (BaseEntity)object.getIssueType(), context, lang)).append(this.appendChange("project", (BaseEntity)original.getProject(), (BaseEntity)object.getProject(), context, lang)).append(this.appendChange("solutiontype", (BaseEntity)original.getSolutionType(), (BaseEntity)object.getSolutionType(), context, lang));
        return content.toString();
    }

    private String appendChange(String key, BaseEntity originalValue, BaseEntity newValue, WebContext.LocalWebContext context, String lang) {
        StringBuilder change = new StringBuilder();
        if (!Objects.equals(originalValue, newValue)) {
            String messageKey = "app.message.edited." + key;
            String changeMessage = context.getMessageTranslation(messageKey, lang);
            change.append("<p>").append(String.format(changeMessage, this.toStr(originalValue), this.toStr(newValue))).append("</p>");
        }
        return change.length() > 0 ? change.toString() : "";
    }

    private String appendParentIssue(IssueModel object, WebContext.LocalWebContext context, String lang) {
        StringBuilder change = new StringBuilder();
        if (Objects.nonNull(object.getParent())) {
            String parentIssueLink = String.valueOf(context.getEnv("app.settings.site.self.ui")) + ISSUE_VIEW_URL + object.getParent().getId();
            change.append("<p>").append(context.getMessageTranslation("app.message.edited.parent", lang)).append("<a href=\"").append(parentIssueLink).append("\">ID").append(object.getParent().getId()).append("</a>").append("</p>");
        }
        return change.length() > 0 ? change.toString() : "";
    }

    public String toStr(BaseEntity hr) {
        return hr == null ? " NOT SET " : hr.asValue();
    }

    private void addViewers(IssueModel object, IssueModel original, WebContext.LocalWebContext context, Set<HRModel> notifiedHRs) {
        try {
            List viewers = ((ViewerService)context.getBean(ViewerService.class)).findByIssue(object);
            HashMap<CallSite, String> data = new HashMap<CallSite, String>();
            for (ViewerModel viewer : viewers) {
                HRModel hr = viewer.getHr();
                if (notifiedHRs.contains(hr)) continue;
                String lang = hr.getDefLanguage();
                data.put((CallSite)((Object)("title_" + lang)), context.getMessageTranslation("app.config.email.issue.edited", lang));
                data.put((CallSite)((Object)("content_" + lang)), this.generateUpdatedNotificationContent(object, original, context, lang));
                ((EmailNotificationChannel)context.getBean(EmailNotificationChannel.class)).generate(data, "issue_updated.html", viewer.getHr());
                ((WebNotificationChannel)context.getBean(WebNotificationChannel.class)).generate(data, "issue_updated.html", viewer.getHr());
                notifiedHRs.add(hr);
            }
        }
        catch (Exception e) {
            throw new NotificationDeliveryException((Serializable)e, "Failed to deliver notification");
        }
    }
}

